/* ===== candidate-detail.js =====
   Scrollspy + smooth scroll untuk nav section kandidat
*/
(function(){
  const nav = document.querySelector('.section-nav');
  const links = Array.from(document.querySelectorAll('.section-nav-link'));
  const sections = links
    .map(a => document.querySelector(a.getAttribute('href')))
    .filter(Boolean);

  if (!nav || !links.length || !sections.length) return;

  // Ambil tinggi topbar sticky dari layout (navbar atas)
  const topbar = document.querySelector('nav.topbar-layer'); // dari layout
  const topbarH = () => (topbar ? topbar.getBoundingClientRect().height : 0);

  // Bikin nav sticky persis di bawah topbar (pakai CSS variable)
  const applyStickyTop = () => {
    const h = topbarH();
    nav.style.position = 'sticky';
    nav.style.top = `${h}px`;
    nav.style.zIndex = 15; // di bawah topbar (20) dan di atas konten
    // Tambah padding top kecil agar konten tidak "ketutup"
    document.documentElement.style.setProperty('--nav-offset', `${h}px`);
  };
  applyStickyTop();
  window.addEventListener('resize', applyStickyTop);

  // Helper: scroll ke target dengan offset header+nav
  const getNavHeight = () => nav.getBoundingClientRect().height;
  const pageOffset = () => topbarH() + getNavHeight() + 12; // +12px breathing room

  const smoothScrollTo = (el) => {
    const rectTop = el.getBoundingClientRect().top + window.scrollY;
    const targetY = Math.max(rectTop - pageOffset(), 0);
    window.scrollTo({ top: targetY, behavior: 'smooth' });
  };

  // Klik link = smooth scroll + update active
  links.forEach(link => {
    link.addEventListener('click', (e) => {
      const href = link.getAttribute('href') || '';
      if (!href.startsWith('#')) return;
      const target = document.querySelector(href);
      if (!target) return;

      e.preventDefault();
      smoothScrollTo(target);

      // update hash tanpa lompat
      history.pushState(null, '', href);
    });
  });

  // Scrollspy pakai IntersectionObserver
  const setActive = (id) => {
    links.forEach(a => a.classList.toggle('active', a.getAttribute('href') === `#${id}`));
  };

  // rootMargin: bagian dianggap aktif saat judul section lewat di bawah nav
  const io = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
      if (entry.isIntersecting) setActive(entry.target.id);
    });
  }, {
    root: null,
    threshold: 0.1,
    // top negative → trigger setelah melewati nav; bottom kecil supaya tidak telat
    rootMargin: () => `-${pageOffset()}px 0px -60% 0px`
  });

  sections.forEach(sec => io.observe(sec));

  // Jika ada hash saat load, scroll ke sana dengan offset
  window.addEventListener('load', () => {
    if (location.hash) {
      const target = document.querySelector(location.hash);
      if (target) setTimeout(() => smoothScrollTo(target), 0);
    }
  });

  // Recalc posisi saat font/asset selesai dimuat
  window.addEventListener('resize', () => {
    // Re-trigger observer margin dengan cara disconnect & connect
    io.disconnect();
    sections.forEach(sec => io.observe(sec));
  });
})();
