<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Employee extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'candidate_id','position_id',
        'employee_code','full_name',
        'company_name','branch','department','position_name','job_level',
        'employment_type','contract_type','start_date','end_date','is_active',
        'base_salary','salary_currency','allowance','meal_transport','other_benefits',
        'npwp','bpjs_ketenagakerjaan','bpjs_kesehatan','tax_status',
        'bank_name','bank_account_no','bank_account_holder',
        'supervisor_name','work_schedule','work_location_detail',
    ];

    protected $casts = [
        'start_date'     => 'date',
        'end_date'       => 'date',
        'is_active'      => 'boolean',
        'base_salary'    => 'decimal:2',
        'allowance'      => 'decimal:2',
        'meal_transport' => 'decimal:2',
        'other_benefits' => 'decimal:2',
    ];

    // Relasi ke kandidat (via kolom candidate_id)
    public function candidate()
    {
        return $this->belongsTo(Candidate::class, 'candidate_id');
    }

    // Relasi ke posisi (via kolom position_id)
    public function position()
    {
        return $this->belongsTo(Position::class, 'position_id');
    }
}
