@extends('layouts.dashboard')

@section('title', 'Approval History - PO Approval System')
@section('page-title', 'Approval History')

@section('content')
<style>
    .history-header {
        background: white;
        border-radius: 10px;
        padding: 25px;
        margin-bottom: 25px;
        box-shadow: var(--shadow);
    }

    .history-stats {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 20px;
        margin-top: 20px;
    }

    .history-stat {
        text-align: center;
        padding: 20px;
        background: var(--bg-light);
        border-radius: 8px;
    }

    .history-stat-value {
        font-size: 32px;
        font-weight: 700;
        color: var(--primary-color);
    }

    .history-stat-value.rejected {
        color: var(--danger-color);
    }

    .history-stat-label {
        font-size: 14px;
        color: var(--text-light);
        margin-top: 5px;
    }

    .filter-section {
        background: white;
        border-radius: 10px;
        padding: 20px;
        margin-bottom: 25px;
        box-shadow: var(--shadow);
    }

    .filter-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 15px;
        margin-top: 15px;
    }

    .history-table-container {
        background: white;
        border-radius: 10px;
        box-shadow: var(--shadow);
        overflow: hidden;
    }

    .history-table {
        width: 100%;
        border-collapse: collapse;
    }

    .history-table thead {
        background: var(--bg-light);
    }

    .history-table th {
        padding: 15px;
        text-align: left;
        font-weight: 600;
        font-size: 13px;
        color: var(--text-dark);
        border-bottom: 2px solid var(--border-color);
    }

    .history-table td {
        padding: 15px;
        border-bottom: 1px solid var(--border-color);
        font-size: 14px;
    }

    .action-badge {
        display: inline-block;
        padding: 4px 12px;
        border-radius: 12px;
        font-size: 12px;
        font-weight: 600;
    }

    .action-badge.approved {
        background: #d4edda;
        color: #155724;
    }

    .action-badge.rejected {
        background: #f8d7da;
        color: #721c24;
    }

    .company-badge {
        display: inline-block;
        padding: 4px 12px;
        border-radius: 12px;
        font-size: 12px;
        font-weight: 600;
    }

    .company-badge.tbi {
        background: #d4edda;
        color: #155724;
    }

    .company-badge.ci {
        background: #d1ecf1;
        color: #0c5460;
    }

    .pagination {
        padding: 20px;
        display: flex;
        justify-content: center;
        gap: 10px;
    }

    .pagination a,
    .pagination span {
        padding: 8px 12px;
        border: 1px solid var(--border-color);
        border-radius: 5px;
        text-decoration: none;
        color: var(--text-dark);
    }

    .pagination a:hover {
        background: var(--primary-color);
        color: white;
        border-color: var(--primary-color);
    }

    .pagination .active {
        background: var(--primary-color);
        color: white;
        border-color: var(--primary-color);
    }

    .no-data {
        text-align: center;
        padding: 60px 20px;
        color: var(--text-light);
    }

    .no-data svg {
        width: 80px;
        height: 80px;
        margin-bottom: 20px;
        opacity: 0.3;
    }

    @media (max-width: 768px) {
        .history-table-container {
            overflow-x: auto;
        }

        .history-table {
            min-width: 800px;
        }
    }
</style>

<div class="history-header">
    <h2 style="margin-bottom: 10px;">Your Approval History</h2>
    <p style="color: var(--text-light);">All purchase orders you have approved or rejected</p>

    <div class="history-stats">
        <div class="history-stat">
            <div class="history-stat-value">{{ $history->where('action', 'approved')->count() }}</div>
            <div class="history-stat-label">Approved (This Page)</div>
        </div>
        <div class="history-stat">
            <div class="history-stat-value rejected">{{ $history->where('action', 'rejected')->count() }}</div>
            <div class="history-stat-label">Rejected (This Page)</div>
        </div>
        <div class="history-stat">
            <div class="history-stat-value">{{ $history->total() }}</div>
            <div class="history-stat-label">Total Records</div>
        </div>
    </div>
</div>

<div class="history-table-container">
    @if($history->count() > 0)
        <table class="history-table">
            <thead>
                <tr>
                    <th>Date & Time</th>
                    <th>Document No</th>
                    <th>Company</th>
                    <th>Category</th>
                    <th>Action</th>
                    <th>Remarks</th>
                </tr>
            </thead>
            <tbody>
                @foreach($history as $item)
                <tr>
                    <td>{{ $item->action_date->format('d M Y H:i') }}</td>
                    <td><strong>{{ $item->document_no }}</strong></td>
                    <td>
                        <span class="company-badge {{ strtolower($item->company) }}">
                            {{ $item->company }}
                        </span>
                    </td>
                    <td>{{ $item->category }}</td>
                    <td>
                        <span class="action-badge {{ $item->action }}">
                            {{ ucfirst($item->action) }}
                        </span>
                    </td>
                    <td>{{ $item->remarks ?: '-' }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <div class="pagination">
            {{ $history->links() }}
        </div>
    @else
        <div class="no-data">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
                <path d="M13 3c-4.97 0-9 4.03-9 9H1l3.89 3.89.07.14L9 12H6c0-3.87 3.13-7 7-7s7 3.13 7 7-3.13 7-7 7c-1.93 0-3.68-.79-4.94-2.06l-1.42 1.42C8.27 19.99 10.51 21 13 21c4.97 0 9-4.03 9-9s-4.03-9-9-9zm-1 5v5l4.28 2.54.72-1.21-3.5-2.08V8H12z"/>
            </svg>
            <h3>No History Found</h3>
            <p>You haven't performed any approval or rejection actions yet.</p>
        </div>
    @endif
</div>
@endsection