<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('approval_history', function (Blueprint $table) {
            // Add composite index for faster lookup
            $table->index(['approver_id', 'document_no'], 'approval_history_approver_doc_index');
        });
    }

    public function down(): void
    {
        Schema::table('approval_history', function (Blueprint $table) {
            $table->dropIndex('approval_history_approver_doc_index');
        });
    }
};