<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('po_detail', function (Blueprint $table) {
            $table->id();
            $table->string('document_no')->index();
            $table->string('company')->index(); // TBI or CI
            $table->string('category')->index(); // HIRBND, HO, CI, HIRBC, RBC, LDR
            $table->string('item_no')->nullable();
            $table->text('description')->nullable();
            $table->decimal('quantity_base', 20, 2)->default(0);
            $table->decimal('amount', 20, 2)->default(0);
            $table->string('shortcut_dimension_1_code')->nullable();
            $table->string('auxiliary_index1')->nullable();
            $table->bigInteger('auxiliary_index2')->nullable();
            $table->timestamps();
            
            // Composite index for faster queries
            $table->index(['document_no', 'company', 'category'], 'po_detail_composite');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('po_detail');
    }
};