<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PoDetail extends Model
{
    protected $table = 'po_detail';

    protected $fillable = [
        'document_no',
        'company',
        'category',
        'item_no',
        'description',
        'quantity_base',
        'unit_of_measure_code',
        'amount',
        'shortcut_dimension_1_code',
        'auxiliary_index1',
        'auxiliary_index2',
    ];

    protected $casts = [
        'quantity_base' => 'decimal:2',
        'amount' => 'decimal:2',
    ];

    public function rekap()
    {
        return $this->belongsTo(PoRekap::class, 'document_no', 'document_no')
                    ->where('company', $this->company)
                    ->where('category', $this->category);
    }
}