<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ApprovalHistory extends Model
{
    protected $table = 'approval_history';

    protected $fillable = [
        'document_no',
        'company',
        'category',
        'approver_id',
        'approver_email',
        'action',
        'remarks',
        'action_date',
        'response_data',
    ];

    protected $casts = [
        'action_date' => 'datetime',
        'response_data' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'approver_id', 'approver_id');
    }
}