<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('user_requests', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id');         // relasi ke company
            $table->unsignedBigInteger('user_id');            // pembuat request (user biasa)
            $table->unsignedBigInteger('pic_id')->nullable(); // PIC / penanggung jawab
            $table->unsignedBigInteger('item_request_id')->nullable(); // nanti diisi setelah item_request dibuat
            $table->string('item_name');                      // nama item inputan user
            $table->string('status')->default('Draft');      // status request
            $table->timestamps();

            $table->foreign('company_id')->references('id')->on('companies')->cascadeOnDelete();
            $table->foreign('user_id')->references('id')->on('users')->cascadeOnDelete();
            $table->foreign('pic_id')->references('id')->on('users')->nullOnDelete();
            $table->foreign('item_request_id')->references('id')->on('item_requests')->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('user_requests');
    }
};
