<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ServiceUsage;

class McpPolicy extends \Google\Collection
{
  protected $collection_key = 'mcpEnableRules';
  /**
   * Output only. The time the policy was created. For singleton policies (such
   * as the `default` policy), this is the first touch of the policy.
   *
   * @var string
   */
  public $createTime;
  /**
   * An opaque tag indicating the current version of the policy, used for
   * concurrency control.
   *
   * @var string
   */
  public $etag;
  protected $mcpEnableRulesType = McpEnableRule::class;
  protected $mcpEnableRulesDataType = 'array';
  /**
   * Output only. The resource name of the policy. Only the `default` policy is
   * supported. We allow the following formats:
   * `projects/{PROJECT_NUMBER}/mcpPolicies/default`,
   * `projects/{PROJECT_ID}/mcpPolicies/default`,
   * `folders/{FOLDER_ID}/mcpPolicies/default`,
   * `organizations/{ORG_ID}/mcpPolicies/default`.
   *
   * @var string
   */
  public $name;
  /**
   * Output only. The time the policy was last updated.
   *
   * @var string
   */
  public $updateTime;

  /**
   * Output only. The time the policy was created. For singleton policies (such
   * as the `default` policy), this is the first touch of the policy.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * An opaque tag indicating the current version of the policy, used for
   * concurrency control.
   *
   * @param string $etag
   */
  public function setEtag($etag)
  {
    $this->etag = $etag;
  }
  /**
   * @return string
   */
  public function getEtag()
  {
    return $this->etag;
  }
  /**
   * McpEnableRules contains MCP enablement related rules.
   *
   * @param McpEnableRule[] $mcpEnableRules
   */
  public function setMcpEnableRules($mcpEnableRules)
  {
    $this->mcpEnableRules = $mcpEnableRules;
  }
  /**
   * @return McpEnableRule[]
   */
  public function getMcpEnableRules()
  {
    return $this->mcpEnableRules;
  }
  /**
   * Output only. The resource name of the policy. Only the `default` policy is
   * supported. We allow the following formats:
   * `projects/{PROJECT_NUMBER}/mcpPolicies/default`,
   * `projects/{PROJECT_ID}/mcpPolicies/default`,
   * `folders/{FOLDER_ID}/mcpPolicies/default`,
   * `organizations/{ORG_ID}/mcpPolicies/default`.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Output only. The time the policy was last updated.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(McpPolicy::class, 'Google_Service_ServiceUsage_McpPolicy');
