<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contactcenterinsights;

class GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint extends \Google\Model
{
  protected $conversationMeasureType = GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure::class;
  protected $conversationMeasureDataType = '';
  protected $dialogflowInteractionMeasureType = GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointDialogflowInteractionMeasure::class;
  protected $dialogflowInteractionMeasureDataType = '';
  protected $intervalType = GoogleTypeInterval::class;
  protected $intervalDataType = '';

  /**
   * The measure related to conversations.
   *
   * @param GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure $conversationMeasure
   */
  public function setConversationMeasure(GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure $conversationMeasure)
  {
    $this->conversationMeasure = $conversationMeasure;
  }
  /**
   * @return GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure
   */
  public function getConversationMeasure()
  {
    return $this->conversationMeasure;
  }
  /**
   * The measure related to dialogflow interactions.
   *
   * @param GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointDialogflowInteractionMeasure $dialogflowInteractionMeasure
   */
  public function setDialogflowInteractionMeasure(GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointDialogflowInteractionMeasure $dialogflowInteractionMeasure)
  {
    $this->dialogflowInteractionMeasure = $dialogflowInteractionMeasure;
  }
  /**
   * @return GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointDialogflowInteractionMeasure
   */
  public function getDialogflowInteractionMeasure()
  {
    return $this->dialogflowInteractionMeasure;
  }
  /**
   * The interval that this data point represents. * If this is the total data
   * point, the interval is [starting create time, ending create time) from the
   * request. * If this a data point from the time series, the interval is
   * [time, time + time granularity from the request).
   *
   * @param GoogleTypeInterval $interval
   */
  public function setInterval(GoogleTypeInterval $interval)
  {
    $this->interval = $interval;
  }
  /**
   * @return GoogleTypeInterval
   */
  public function getInterval()
  {
    return $this->interval;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint::class, 'Google_Service_Contactcenterinsights_GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint');
