<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudRetail;

class GoogleCloudRetailV2PriceInfoPriceRange extends \Google\Model
{
  protected $originalPriceType = GoogleCloudRetailV2Interval::class;
  protected $originalPriceDataType = '';
  protected $priceType = GoogleCloudRetailV2Interval::class;
  protected $priceDataType = '';

  /**
   * The inclusive Product.pricing_info.original_price internal of all variant
   * Product having the same Product.primary_product_id.
   *
   * @param GoogleCloudRetailV2Interval $originalPrice
   */
  public function setOriginalPrice(GoogleCloudRetailV2Interval $originalPrice)
  {
    $this->originalPrice = $originalPrice;
  }
  /**
   * @return GoogleCloudRetailV2Interval
   */
  public function getOriginalPrice()
  {
    return $this->originalPrice;
  }
  /**
   * The inclusive Product.pricing_info.price interval of all variant Product
   * having the same Product.primary_product_id.
   *
   * @param GoogleCloudRetailV2Interval $price
   */
  public function setPrice(GoogleCloudRetailV2Interval $price)
  {
    $this->price = $price;
  }
  /**
   * @return GoogleCloudRetailV2Interval
   */
  public function getPrice()
  {
    return $this->price;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudRetailV2PriceInfoPriceRange::class, 'Google_Service_CloudRetail_GoogleCloudRetailV2PriceInfoPriceRange');
