<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Bigquery;

class GlobalExplanation extends \Google\Collection
{
  protected $collection_key = 'explanations';
  /**
   * Class label for this set of global explanations. Will be empty/null for
   * binary logistic and linear regression models. Sorted alphabetically in
   * descending order.
   *
   * @var string
   */
  public $classLabel;
  protected $explanationsType = Explanation::class;
  protected $explanationsDataType = 'array';

  /**
   * Class label for this set of global explanations. Will be empty/null for
   * binary logistic and linear regression models. Sorted alphabetically in
   * descending order.
   *
   * @param string $classLabel
   */
  public function setClassLabel($classLabel)
  {
    $this->classLabel = $classLabel;
  }
  /**
   * @return string
   */
  public function getClassLabel()
  {
    return $this->classLabel;
  }
  /**
   * A list of the top global explanations. Sorted by absolute value of
   * attribution in descending order.
   *
   * @param Explanation[] $explanations
   */
  public function setExplanations($explanations)
  {
    $this->explanations = $explanations;
  }
  /**
   * @return Explanation[]
   */
  public function getExplanations()
  {
    return $this->explanations;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GlobalExplanation::class, 'Google_Service_Bigquery_GlobalExplanation');
