<?php

namespace App\Jobs;

use App\Services\GoogleDriveService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class UploadSignedPdfToDrive
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected string $pdfPath;
    protected string $fileName;
    protected ?int $formId;

    public function __construct(string $pdfPath, string $fileName, ?int $formId = null)
    {
        $this->pdfPath  = $pdfPath;
        $this->fileName = $fileName;
        $this->formId   = $formId;
    }

    public function handle(GoogleDriveService $drive)
    {
        if (!file_exists($this->pdfPath)) {
            Log::error('Drive upload failed: file not found', [
                'path' => $this->pdfPath,
            ]);
            return;
        }

        try {
            $result = $drive->uploadPdf(
                $this->pdfPath,
                $this->fileName,
                config('services.google.drive_folder_id')
            );

            if ($this->formId) {
                \DB::table('uploaded_forms')
                    ->where('id', $this->formId)
                    ->update([
                        'drive_file_id' => $result['id'],
                        'drive_link'    => $result['link'],
                    ]);
            }

        } catch (\Throwable $e) {
            Log::error('Drive upload exception', [
                'error' => $e->getMessage(),
            ]);
        }
    }
}
