<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DisplayVideo;

class AppCategoryAssignedTargetingOptionDetails extends \Google\Model
{
  /**
   * Output only. The display name of the app category.
   *
   * @var string
   */
  public $displayName;
  /**
   * Indicates if this option is being negatively targeted.
   *
   * @var bool
   */
  public $negative;
  /**
   * Required. The targeting_option_id field when targeting_type is
   * `TARGETING_TYPE_APP_CATEGORY`.
   *
   * @var string
   */
  public $targetingOptionId;

  /**
   * Output only. The display name of the app category.
   *
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * Indicates if this option is being negatively targeted.
   *
   * @param bool $negative
   */
  public function setNegative($negative)
  {
    $this->negative = $negative;
  }
  /**
   * @return bool
   */
  public function getNegative()
  {
    return $this->negative;
  }
  /**
   * Required. The targeting_option_id field when targeting_type is
   * `TARGETING_TYPE_APP_CATEGORY`.
   *
   * @param string $targetingOptionId
   */
  public function setTargetingOptionId($targetingOptionId)
  {
    $this->targetingOptionId = $targetingOptionId;
  }
  /**
   * @return string
   */
  public function getTargetingOptionId()
  {
    return $this->targetingOptionId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AppCategoryAssignedTargetingOptionDetails::class, 'Google_Service_DisplayVideo_AppCategoryAssignedTargetingOptionDetails');
