<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Dashboard'); ?> - Kasir Calculator</title>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <!-- Navbar -->
    <div class="navbar">
        <a href="#" class="navbar-brand">
            <img src="<?php echo e(asset('assets/images/perusahaan.png')); ?>" alt="Logo">
            <span>KAYU MEBEL INDONESIA</span>
        </a>
        <div style="display: flex; align-items: center; gap: 20px;">
            <span style="color: var(--gray-600); font-size: 14px;"><?php echo e(Auth::user()->name); ?></span>
            <form action="<?php echo e(route('logout')); ?>" method="POST" style="margin: 0;">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn btn-secondary" style="padding: 8px 16px;">Logout</button>
            </form>
        </div>
    </div>

    <div class="container-fluid">
        <!-- Sidebar -->
        <aside class="sidebar">
            <?php echo $__env->yieldContent('sidebar'); ?>
        </aside>

        <!-- Main Content -->
        <main class="main-content">
            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH C:\xampp\htdocs\kasir_calculator\resources\views/layouts/app.blade.php ENDPATH**/ ?>