

<?php $__env->startSection('title', 'Data Buyers'); ?>

<?php $__env->startSection('sidebar'); ?>
<ul class="sidebar-menu">
    <li><a href="<?php echo e(route('superadmin.dashboard')); ?>">📊 Dashboard</a></li>
    <li><a href="<?php echo e(route('superadmin.buyers.index')); ?>" class="active">👥 Buyers</a></li>
    <li><a href="<?php echo e(route('superadmin.products.index')); ?>">📦 Products</a></li>
    <li><a href="<?php echo e(route('superadmin.materials.index')); ?>">🪵 Materials</a></li>
    <li><a href="<?php echo e(route('superadmin.veneers.index')); ?>">🎨 Veneers</a></li>
    <li><a href="<?php echo e(route('superadmin.components.index')); ?>">🔧 Components</a></li>
    <li><a href="<?php echo e(route('superadmin.dimensions.index')); ?>">📐 Dimensions</a></li>
</ul>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div style="margin-bottom: 30px; display: flex; justify-content: space-between; align-items: center;">
    <div>
        <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Data Buyers</h1>
        <p style="color: var(--gray-600);">Kelola data buyer/customer</p>
    </div>
    <a href="<?php echo e(route('superadmin.buyers.create')); ?>" class="btn btn-primary">+ Tambah Buyer</a>
</div>

<?php if(session('success')): ?>
<div style="background: #d1fae5; border: 1px solid #86efac; padding: 12px 20px; border-radius: 8px; margin-bottom: 20px; color: #065f46;">
    <?php echo e(session('success')); ?>

</div>
<?php endif; ?>

<div class="card">
    <table style="width: 100%; border-collapse: collapse;">
        <thead>
            <tr style="background: var(--gray-100); text-align: left;">
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">#</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">Kode</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">Nama</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">Email</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">Phone</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">Status</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300); text-align: center;">Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $buyers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $buyer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);"><?php echo e($buyers->firstItem() + $index); ?></td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);"><strong><?php echo e($buyer->code); ?></strong></td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);"><?php echo e($buyer->name); ?></td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);"><?php echo e($buyer->email ?? '-'); ?></td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);"><?php echo e($buyer->phone ?? '-'); ?></td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);">
                    <?php if($buyer->is_active): ?>
                        <span style="background: #d1fae5; color: #065f46; padding: 4px 12px; border-radius: 12px; font-size: 12px;">Aktif</span>
                    <?php else: ?>
                        <span style="background: #fee2e2; color: #991b1b; padding: 4px 12px; border-radius: 12px; font-size: 12px;">Nonaktif</span>
                    <?php endif; ?>
                </td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200); text-align: center;">
                    <a href="<?php echo e(route('superadmin.buyers.edit', $buyer->id)); ?>" class="btn btn-secondary" style="padding: 6px 12px; margin-right: 5px;">Edit</a>
                    <form action="<?php echo e(route('superadmin.buyers.destroy', $buyer->id)); ?>" method="POST" style="display: inline-block;" onsubmit="return confirm('Yakin ingin menghapus buyer ini?')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn" style="padding: 6px 12px; background: #ef4444; color: white;">Hapus</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="7" style="padding: 40px; text-align: center; color: var(--gray-500);">
                    Belum ada data buyer. <a href="<?php echo e(route('superadmin.buyers.create')); ?>" style="color: var(--primary-green);">Tambah buyer pertama</a>
                </td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div style="margin-top: 20px;">
        <?php echo e($buyers->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\kasir_calculator\resources\views/superadmin/buyers/index.blade.php ENDPATH**/ ?>