

<?php $__env->startSection('title', 'Pilih Buyer'); ?>

<?php $__env->startSection('sidebar'); ?>
<ul class="sidebar-menu">
    <li><a href="<?php echo e(route('admin.dashboard')); ?>">📊 Dashboard</a></li>
    <li><a href="<?php echo e(route('admin.quotations.create')); ?>" class="active">🛒 Pemesanan Baru</a></li>
    <li><a href="<?php echo e(route('admin.quotations.index')); ?>">📄 Riwayat Quotations</a></li>
</ul>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div style="margin-bottom: 30px;">
    <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Buat Quotation Baru</h1>
    <p style="color: var(--gray-600);">Step 1 dari 3: Pilih Buyer/Customer</p>
</div>

<!-- Progress Bar -->
<div style="background: var(--gray-200); height: 8px; border-radius: 4px; margin-bottom: 30px; overflow: hidden;">
    <div style="background: var(--primary-green); height: 100%; width: 33%;"></div>
</div>

<form action="<?php echo e(route('admin.quotations.select-product')); ?>" method="POST">
    <?php echo csrf_field(); ?>
    
    <h2 style="font-size: 20px; margin-bottom: 20px; color: var(--gray-800);">Pilih Buyer/Customer</h2>
    
    <div class="grid grid-3">
        <?php $__empty_1 = true; $__currentLoopData = $buyers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $buyer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <label class="card buyer-card" style="cursor: pointer; transition: all 0.3s ease;">
            <input type="radio" name="buyer_id" value="<?php echo e($buyer->id); ?>" required style="display: none;" class="buyer-radio">
            
            <div style="display: flex; justify-content: space-between; align-items: start; margin-bottom: 15px;">
                <div style="width: 60px; height: 60px; background: var(--primary-green-light); border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                    <span style="font-size: 28px;">👤</span>
                </div>
                <div class="checkmark-container" style="display: none;">
                    <span class="checkmark">✓</span>
                </div>
            </div>
            
            <h3 style="font-size: 18px; color: var(--gray-800); margin-bottom: 5px;"><?php echo e($buyer->name); ?></h3>
            <p style="color: var(--primary-green); font-weight: 600; font-size: 14px; margin-bottom: 10px;"><?php echo e($buyer->code); ?></p>
            
            <?php if($buyer->email): ?>
            <p style="color: var(--gray-600); font-size: 13px; margin-bottom: 5px;">📧 <?php echo e($buyer->email); ?></p>
            <?php endif; ?>
            
            <?php if($buyer->phone): ?>
            <p style="color: var(--gray-600); font-size: 13px;">📞 <?php echo e($buyer->phone); ?></p>
            <?php endif; ?>
        </label>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div style="grid-column: 1 / -1; text-align: center; padding: 60px; color: var(--gray-500);">
            <div style="font-size: 64px; margin-bottom: 20px;">👥</div>
            <p style="font-size: 18px;">Belum ada data buyer. Silakan hubungi SuperAdmin untuk menambahkan buyer.</p>
        </div>
        <?php endif; ?>
    </div>

    <?php if($buyers->count() > 0): ?>
    <div style="margin-top: 30px; display: flex; gap: 10px;">
        <button type="submit" class="btn btn-primary" id="nextBtn" disabled>Lanjut ke Step 2 →</button>
        <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-secondary">Batal</a>
    </div>
    <?php endif; ?>
</form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .buyer-card {
        position: relative;
        border: 2px solid transparent;
    }
    
    .buyer-card:hover {
        border-color: var(--primary-green);
        transform: translateY(-4px);
    }
    
    .buyer-card.selected {
        border-color: var(--primary-green);
        background: var(--primary-green-light);
    }
    
    .checkmark-container {
        background: var(--primary-green);
        width: 30px;
        height: 30px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .checkmark {
        color: white;
        font-size: 18px;
        font-weight: bold;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const buyerCards = document.querySelectorAll('.buyer-card');
        const nextBtn = document.getElementById('nextBtn');
        
        buyerCards.forEach(card => {
            card.addEventListener('click', function() {
                // Remove selected class from all cards
                buyerCards.forEach(c => {
                    c.classList.remove('selected');
                    c.querySelector('.checkmark-container').style.display = 'none';
                });
                
                // Add selected class to clicked card
                this.classList.add('selected');
                this.querySelector('.checkmark-container').style.display = 'flex';
                
                // Check the radio button
                this.querySelector('.buyer-radio').checked = true;
                
                // Enable next button
                nextBtn.disabled = false;
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\kasir_calculator\resources\views/admin/quotations/step1-buyer.blade.php ENDPATH**/ ?>