

<?php $__env->startSection('title', 'Detail Quotation'); ?>

<?php $__env->startSection('sidebar'); ?>
<ul class="sidebar-menu">
    <li><a href="<?php echo e(route('admin.dashboard')); ?>">📊 Dashboard</a></li>
    <li><a href="<?php echo e(route('admin.quotations.create')); ?>">🛒 Pemesanan Baru</a></li>
    <li><a href="<?php echo e(route('admin.quotations.index')); ?>" class="active">📄 Riwayat Quotations</a></li>
</ul>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div style="margin-bottom: 30px; display: flex; justify-content: space-between; align-items: center;">
    <div>
        <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Detail Quotation</h1>
        <p style="color: var(--gray-600);"><?php echo e($quotation->quotation_number); ?></p>
    </div>
    <div style="display: flex; gap: 10px;">
        <button onclick="window.print()" class="btn btn-primary">🖨️ Print / PDF</button>
        <a href="<?php echo e(route('admin.quotations.index')); ?>" class="btn btn-secondary">← Kembali</a>
    </div>
</div>

<?php if(session('success')): ?>
<div style="background: #d1fae5; border: 1px solid #86efac; padding: 12px 20px; border-radius: 8px; margin-bottom: 20px; color: #065f46;">
    <?php echo e(session('success')); ?>

</div>
<?php endif; ?>

<!-- Invoice Detail (Invoice Detail seperti gambar 1) -->
<div class="card" id="invoice-print">
    <!-- Header -->
    <div style="display: flex; justify-content: between; align-items: start; margin-bottom: 30px; border-bottom: 3px solid var(--primary-green); padding-bottom: 20px;">
        <div style="flex: 1;">
            <img src="<?php echo e(asset('assets/images/perusahaan.png')); ?>" alt="Logo" style="height: 60px; margin-bottom: 15px;">
            <h1 style="font-size: 24px; color: var(--gray-800); margin-bottom: 5px;">KAYU MEBEL INDONESIA</h1>
            <p style="color: var(--gray-600); font-size: 14px;">Bill of Material (Mass Product)</p>
        </div>
        <div style="text-align: right;">
            <p style="font-size: 14px; color: var(--gray-600); margin-bottom: 5px;">Quotation Number:</p>
            <p style="font-size: 20px; font-weight: 700; color: var(--primary-green); margin-bottom: 15px;"><?php echo e($quotation->quotation_number); ?></p>
            <p style="font-size: 14px; color: var(--gray-600);">Date: <?php echo e($quotation->created_at->format('d F Y')); ?></p>
        </div>
    </div>

    <!-- Product Info -->
    <div style="background: var(--gray-50); padding: 20px; border-radius: 8px; margin-bottom: 30px;">
        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
            <div>
                <p style="font-size: 14px; color: var(--gray-600); margin-bottom: 5px;">Product Name:</p>
                <p style="font-size: 16px; font-weight: 600; color: var(--gray-800);"><?php echo e($quotation->product->name); ?></p>
            </div>
            <div>
                <p style="font-size: 14px; color: var(--gray-600); margin-bottom: 5px;">Product Type:</p>
                <p style="font-size: 16px; font-weight: 600; color: var(--gray-800);"><?php echo e($quotation->product->code); ?></p>
            </div>
            <div>
                <p style="font-size: 14px; color: var(--gray-600); margin-bottom: 5px;">Buyer:</p>
                <p style="font-size: 16px; font-weight: 600; color: var(--gray-800);"><?php echo e($quotation->buyer->name); ?></p>
            </div>
            <div>
                <p style="font-size: 14px; color: var(--gray-600); margin-bottom: 5px;">Order:</p>
                <p style="font-size: 16px; font-weight: 600; color: var(--gray-800);">1 Pcs</p>
            </div>
        </div>
    </div>

    <!-- Component Details Table -->
    <h3 style="font-size: 18px; margin-bottom: 15px; color: var(--gray-800);">KOMPONEN</h3>
    
    <table style="width: 100%; border-collapse: collapse; margin-bottom: 30px;">
        <thead>
            <tr style="background: var(--primary-green); color: white;">
                <th style="padding: 12px; text-align: left; border: 1px solid var(--gray-300);">No.</th>
                <th style="padding: 12px; text-align: left; border: 1px solid var(--gray-300);">Component Name</th>
                <th style="padding: 12px; text-align: left; border: 1px solid var(--gray-300);">Material</th>
                <th style="padding: 12px; text-align: center; border: 1px solid var(--gray-300);">Dimensions</th>
                <th style="padding: 12px; text-align: center; border: 1px solid var(--gray-300);">M²</th>
                <th style="padding: 12px; text-align: center; border: 1px solid var(--gray-300);">Qty</th>
                <th style="padding: 12px; text-align: right; border: 1px solid var(--gray-300);">Price</th>
                <th style="padding: 12px; text-align: right; border: 1px solid var(--gray-300);">Total</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $quotation->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td style="padding: 10px; border: 1px solid var(--gray-300); text-align: center;"><?php echo e($index + 1); ?></td>
                <td style="padding: 10px; border: 1px solid var(--gray-300);"><strong><?php echo e($detail->component_name); ?></strong></td>
                <td style="padding: 10px; border: 1px solid var(--gray-300);"><?php echo e($detail->material_type ?? '-'); ?></td>
                <td style="padding: 10px; border: 1px solid var(--gray-300); text-align: center;">
                    <?php if($detail->width && $detail->length): ?>
                        <?php echo e($detail->width); ?> × <?php echo e($detail->length); ?> mm
                    <?php else: ?>
                        -
                    <?php endif; ?>
                </td>
                <td style="padding: 10px; border: 1px solid var(--gray-300); text-align: center;">
                    <?php if($detail->m2): ?>
                        <?php echo e(number_format($detail->m2, 6)); ?>

                    <?php else: ?>
                        -
                    <?php endif; ?>
                </td>
                <td style="padding: 10px; border: 1px solid var(--gray-300); text-align: center;"><?php echo e($detail->qty); ?></td>
                <td style="padding: 10px; border: 1px solid var(--gray-300); text-align: right;">Rp <?php echo e(number_format($detail->price_per_unit, 0, ',', '.')); ?></td>
                <td style="padding: 10px; border: 1px solid var(--gray-300); text-align: right;"><strong>Rp <?php echo e(number_format($detail->subtotal, 0, ',', '.')); ?></strong></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
            <!-- Total Row -->
            <tr style="background: var(--gray-100);">
                <td colspan="7" style="padding: 15px; border: 1px solid var(--gray-300); text-align: right;"><strong style="font-size: 18px;">TOTAL</strong></td>
                <td style="padding: 15px; border: 1px solid var(--gray-300); text-align: right;"><strong style="font-size: 20px; color: var(--primary-green);">Rp <?php echo e(number_format($quotation->total_price, 0, ',', '.')); ?></strong></td>
            </tr>
        </tbody>
    </table>

    <!-- Invoice Point Summary (seperti gambar 2) -->
    <div style="page-break-before: always; margin-top: 40px;">
        <h3 style="font-size: 18px; margin-bottom: 15px; color: var(--gray-800); border-bottom: 2px solid var(--primary-green); padding-bottom: 10px;">TOTAL PERHITUNGAN CONTOH:</h3>
        
        <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
            <thead>
                <tr style="background: var(--gray-100);">
                    <th style="padding: 12px; text-align: left; border: 1px solid var(--gray-300);">No</th>
                    <th style="padding: 12px; text-align: left; border: 1px solid var(--gray-300);">Komponen</th>
                    <th style="padding: 12px; text-align: left; border: 1px solid var(--gray-300);">Perhitungan</th>
                    <th style="padding: 12px; text-align: right; border: 1px solid var(--gray-300);">Harga</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $quotation->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td style="padding: 10px; border: 1px solid var(--gray-300); text-align: center;"><?php echo e($index + 1); ?></td>
                    <td style="padding: 10px; border: 1px solid var(--gray-300);"><?php echo e($detail->component_name); ?> <?php if($detail->material_type): ?>(<?php echo e($detail->material_type); ?>)<?php endif; ?></td>
                    <td style="padding: 10px; border: 1px solid var(--gray-300); font-family: monospace; font-size: 13px;"><?php echo e($detail->note ?? '-'); ?></td>
                    <td style="padding: 10px; border: 1px solid var(--gray-300); text-align: right;"><strong>Rp <?php echo e(number_format($detail->subtotal, 0, ',', '.')); ?></strong></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                <!-- Total Row -->
                <tr style="background: var(--primary-green-light);">
                    <td colspan="3" style="padding: 15px; border: 1px solid var(--gray-300); text-align: right;"><strong style="font-size: 16px;">TOTAL</strong></td>
                    <td style="padding: 15px; border: 1px solid var(--gray-300); text-align: right;"><strong style="font-size: 18px; color: var(--primary-green);">Rp <?php echo e(number_format($quotation->total_price, 0, ',', '.')); ?></strong></td>
                </tr>
            </tbody>
        </table>
    </div>

    <!-- Footer -->
    <div style="margin-top: 40px; padding-top: 20px; border-top: 2px solid var(--gray-200);">
        <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 30px; text-align: center;">
            <div>
                <p style="font-size: 14px; color: var(--gray-600); margin-bottom: 60px;">Dibuat Oleh:</p>
                <p style="border-top: 1px solid var(--gray-400); padding-top: 5px; font-weight: 600;"><?php echo e($quotation->user->name); ?></p>
                <p style="font-size: 12px; color: var(--gray-500);">Admin</p>
            </div>
            <div>
                <p style="font-size: 14px; color: var(--gray-600); margin-bottom: 60px;">Diperiksa Oleh:</p>
                <p style="border-top: 1px solid var(--gray-400); padding-top: 5px; font-weight: 600;">_________________</p>
                <p style="font-size: 12px; color: var(--gray-500);">Manager</p>
            </div>
            <div>
                <p style="font-size: 14px; color: var(--gray-600); margin-bottom: 60px;">Disetujui Oleh:</p>
                <p style="border-top: 1px solid var(--gray-400); padding-top: 5px; font-weight: 600;">_________________</p>
                <p style="font-size: 12px; color: var(--gray-500);">Director</p>
            </div>
        </div>
    </div>

    <div style="margin-top: 30px; text-align: center; color: var(--gray-500); font-size: 12px; padding-top: 20px; border-top: 1px solid var(--gray-200);">
        <p>KAYU MEBEL INDONESIA © <?php echo e(date('Y')); ?> | <?php echo e($quotation->quotation_number); ?></p>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    @media print {
        body * {
            visibility: hidden;
        }
        
        #invoice-print, #invoice-print * {
            visibility: visible;
        }
        
        #invoice-print {
            position: absolute;
            left: 0;
            top: 0;
            width: 100%;
            padding: 20px;
        }
        
        .sidebar, .navbar, .btn, .no-print {
            display: none !important;
        }
        
        .card {
            box-shadow: none;
            border: none;
        }
        
        @page {
            size: A4;
            margin: 15mm;
        }
    }
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\kasir_calculator\resources\views/admin/quotations/show.blade.php ENDPATH**/ ?>