<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\SuperAdmin\DashboardController as SuperAdminDashboardController;
use App\Http\Controllers\SuperAdmin\BuyerController;
use App\Http\Controllers\SuperAdmin\ProductController;
use App\Http\Controllers\SuperAdmin\MaterialController;
use App\Http\Controllers\SuperAdmin\VeneerController;
use App\Http\Controllers\SuperAdmin\OtherComponentController;
use App\Http\Controllers\SuperAdmin\ComponentDimensionController;
use App\Http\Controllers\Admin\DashboardController as AdminDashboardController;

// Authentication Routes
Route::get('/', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.post');
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// SuperAdmin Routes
Route::prefix('superadmin')->name('superadmin.')->middleware(['auth', 'role:superadmin'])->group(function () {
    Route::get('/dashboard', [SuperAdminDashboardController::class, 'index'])->name('dashboard');
    
    // Master Data Routes
    Route::resource('buyers', BuyerController::class);
    Route::resource('products', ProductController::class);
    Route::resource('materials', MaterialController::class);
    Route::resource('veneers', VeneerController::class);
    Route::resource('components', OtherComponentController::class);
    Route::resource('dimensions', ComponentDimensionController::class);
});

// Admin Routes
Route::prefix('admin')->name('admin.')->middleware(['auth', 'role:admin'])->group(function () {
    Route::get('/dashboard', [AdminDashboardController::class, 'index'])->name('dashboard');
    
    // Quotation Routes
    Route::get('/quotations', [App\Http\Controllers\Admin\QuotationController::class, 'index'])->name('quotations.index');
    Route::get('/quotations/create', [App\Http\Controllers\Admin\QuotationController::class, 'create'])->name('quotations.create');
    Route::post('/quotations/select-product', [App\Http\Controllers\Admin\QuotationController::class, 'selectProduct'])->name('quotations.select-product');
    Route::post('/quotations/build-components', [App\Http\Controllers\Admin\QuotationController::class, 'buildComponents'])->name('quotations.build-components');
    Route::post('/quotations/calculate-component', [App\Http\Controllers\Admin\QuotationController::class, 'calculateComponent'])->name('quotations.calculate-component');
    Route::post('/quotations', [App\Http\Controllers\Admin\QuotationController::class, 'store'])->name('quotations.store');
    Route::get('/quotations/{quotation}', [App\Http\Controllers\Admin\QuotationController::class, 'show'])->name('quotations.show');
    Route::delete('/quotations/{quotation}', [App\Http\Controllers\Admin\QuotationController::class, 'destroy'])->name('quotations.destroy');
});