@extends('layouts.app')

@section('title', 'Data Veneers')

@section('sidebar')
<ul class="sidebar-menu">
    <li><a href="{{ route('superadmin.dashboard') }}">📊 Dashboard</a></li>
    <li><a href="{{ route('superadmin.buyers.index') }}">👥 Buyers</a></li>
    <li><a href="{{ route('superadmin.products.index') }}">📦 Products</a></li>
    <li><a href="{{ route('superadmin.materials.index') }}">🪵 Materials</a></li>
    <li><a href="{{ route('superadmin.veneers.index') }}" class="active">🎨 Veneers</a></li>
    <li><a href="{{ route('superadmin.components.index') }}">🔧 Components</a></li>
    <li><a href="{{ route('superadmin.dimensions.index') }}">📐 Dimensions</a></li>
</ul>
@endsection

@section('content')
<div style="margin-bottom: 30px; display: flex; justify-content: space-between; align-items: center;">
    <div>
        <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Data Veneers</h1>
        <p style="color: var(--gray-600);">Kelola data veneer (Lurus & Motif)</p>
    </div>
    <a href="{{ route('superadmin.veneers.create') }}" class="btn btn-primary">+ Tambah Veneer</a>
</div>

@if(session('success'))
<div style="background: #d1fae5; border: 1px solid #86efac; padding: 12px 20px; border-radius: 8px; margin-bottom: 20px; color: #065f46;">
    {{ session('success') }}
</div>
@endif

<div class="grid grid-4">
    @forelse($veneers as $veneer)
    <div class="card" style="position: relative;">
        <!-- Badge Pattern -->
        <div style="position: absolute; top: 15px; right: 15px; display: flex; gap: 5px; flex-direction: column; align-items: flex-end;">
            @if($veneer->pattern == 'lurus')
                <span style="background: #dbeafe; color: #1e40af; padding: 4px 12px; border-radius: 12px; font-size: 11px; font-weight: 600; text-transform: uppercase;">Lurus</span>
            @else
                <span style="background: #fef3c7; color: #92400e; padding: 4px 12px; border-radius: 12px; font-size: 11px; font-weight: 600; text-transform: uppercase;">Motif</span>
            @endif
            
            @if($veneer->is_active)
                <span style="background: #d1fae5; color: #065f46; padding: 4px 12px; border-radius: 12px; font-size: 11px; font-weight: 600;">Aktif</span>
            @else
                <span style="background: #fee2e2; color: #991b1b; padding: 4px 12px; border-radius: 12px; font-size: 11px; font-weight: 600;">Nonaktif</span>
            @endif
        </div>

        <!-- Icon -->
        <div style="width: 80px; height: 80px; background: #fce7f3; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 15px;">
            <span style="font-size: 40px;">🎨</span>
        </div>

        <h3 style="font-size: 18px; color: var(--gray-800); margin-bottom: 5px; text-align: center;">{{ $veneer->name }}</h3>
        <p style="color: var(--gray-600); font-size: 14px; text-align: center; margin-bottom: 15px;">
            Tebal: <strong>{{ $veneer->thickness }} mm</strong>
        </p>

        <!-- Harga -->
        <div style="background: var(--gray-50); padding: 12px; border-radius: 8px; margin-bottom: 15px;">
            <p style="font-size: 12px; color: var(--gray-600); margin-bottom: 5px;">Harga per M²</p>
            <p style="font-size: 20px; font-weight: 700; color: var(--primary-green);">Rp {{ number_format($veneer->price_per_m2, 0, ',', '.') }}</p>
        </div>

        <div style="display: flex; gap: 10px;">
            <a href="{{ route('superadmin.veneers.edit', $veneer->id) }}" class="btn btn-secondary" style="flex: 1; text-align: center; text-decoration: none;">Edit</a>
            <form action="{{ route('superadmin.veneers.destroy', $veneer->id) }}" method="POST" style="flex: 1;" onsubmit="return confirm('Yakin ingin menghapus veneer ini?')">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn" style="width: 100%; background: #ef4444; color: white;">Hapus</button>
            </form>
        </div>
    </div>
    @empty
    <div style="grid-column: 1 / -1; text-align: center; padding: 60px; color: var(--gray-500);">
        <div style="font-size: 64px; margin-bottom: 20px;">🎨</div>
        <p style="font-size: 18px; margin-bottom: 10px;">Belum ada data veneer</p>
        <a href="{{ route('superadmin.veneers.create') }}" style="color: var(--primary-green); font-weight: 600;">Tambah veneer pertama</a>
    </div>
    @endforelse
</div>

<div style="margin-top: 30px;">
    {{ $veneers->links() }}
</div>
@endsection