@extends('layouts.app')

@section('title', 'Data Products')

@section('sidebar')
<ul class="sidebar-menu">
    <li><a href="{{ route('superadmin.dashboard') }}">📊 Dashboard</a></li>
    <li><a href="{{ route('superadmin.buyers.index') }}">👥 Buyers</a></li>
    <li><a href="{{ route('superadmin.products.index') }}" class="active">📦 Products</a></li>
    <li><a href="{{ route('superadmin.materials.index') }}">🪵 Materials</a></li>
    <li><a href="{{ route('superadmin.veneers.index') }}">🎨 Veneers</a></li>
    <li><a href="{{ route('superadmin.components.index') }}">🔧 Components</a></li>
    <li><a href="{{ route('superadmin.dimensions.index') }}">📐 Dimensions</a></li>
</ul>
@endsection

@section('content')
<div style="margin-bottom: 30px; display: flex; justify-content: space-between; align-items: center;">
    <div>
        <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Data Products</h1>
        <p style="color: var(--gray-600);">Kelola data produk furniture</p>
    </div>
    <a href="{{ route('superadmin.products.create') }}" class="btn btn-primary">+ Tambah Product</a>
</div>

@if(session('success'))
<div style="background: #d1fae5; border: 1px solid #86efac; padding: 12px 20px; border-radius: 8px; margin-bottom: 20px; color: #065f46;">
    {{ session('success') }}
</div>
@endif

<div class="grid grid-3">
    @forelse($products as $product)
    <div class="card" style="position: relative;">
        @if($product->image)
            <img src="{{ asset('assets/images/products/' . $product->image) }}" alt="{{ $product->name }}" style="width: 100%; height: 200px; object-fit: cover; border-radius: 8px; margin-bottom: 15px;">
        @else
            <div style="width: 100%; height: 200px; background: var(--gray-200); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-bottom: 15px;">
                <span style="font-size: 48px;">📦</span>
            </div>
        @endif
        
        <div style="position: absolute; top: 15px; right: 15px;">
            @if($product->is_active)
                <span style="background: #d1fae5; color: #065f46; padding: 4px 12px; border-radius: 12px; font-size: 12px; font-weight: 600;">Aktif</span>
            @else
                <span style="background: #fee2e2; color: #991b1b; padding: 4px 12px; border-radius: 12px; font-size: 12px; font-weight: 600;">Nonaktif</span>
            @endif
        </div>

        <h3 style="font-size: 18px; color: var(--gray-800); margin-bottom: 5px;">{{ $product->name }}</h3>
        <p style="color: var(--primary-green); font-weight: 600; font-size: 14px; margin-bottom: 10px;">{{ $product->code }}</p>
        <p style="color: var(--gray-600); font-size: 14px; margin-bottom: 15px; line-height: 1.5;">
            {{ $product->description ? Str::limit($product->description, 80) : 'Tidak ada deskripsi' }}
        </p>

        <div style="display: flex; gap: 10px;">
            <a href="{{ route('superadmin.products.edit', $product->id) }}" class="btn btn-secondary" style="flex: 1; text-align: center; text-decoration: none;">Edit</a>
            <form action="{{ route('superadmin.products.destroy', $product->id) }}" method="POST" style="flex: 1;" onsubmit="return confirm('Yakin ingin menghapus product ini?')">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn" style="width: 100%; background: #ef4444; color: white;">Hapus</button>
            </form>
        </div>
    </div>
    @empty
    <div style="grid-column: 1 / -1; text-align: center; padding: 60px; color: var(--gray-500);">
        <div style="font-size: 64px; margin-bottom: 20px;">📦</div>
        <p style="font-size: 18px; margin-bottom: 10px;">Belum ada data product</p>
        <a href="{{ route('superadmin.products.create') }}" style="color: var(--primary-green); font-weight: 600;">Tambah product pertama</a>
    </div>
    @endforelse
</div>

<div style="margin-top: 30px;">
    {{ $products->links() }}
</div>
@endsection