@extends('layouts.app')

@section('title', 'Data Components')

@section('sidebar')
<ul class="sidebar-menu">
    <li><a href="{{ route('superadmin.dashboard') }}">📊 Dashboard</a></li>
    <li><a href="{{ route('superadmin.buyers.index') }}">👥 Buyers</a></li>
    <li><a href="{{ route('superadmin.products.index') }}">📦 Products</a></li>
    <li><a href="{{ route('superadmin.materials.index') }}">🪵 Materials</a></li>
    <li><a href="{{ route('superadmin.veneers.index') }}">🎨 Veneers</a></li>
    <li><a href="{{ route('superadmin.components.index') }}" class="active">🔧 Components</a></li>
    <li><a href="{{ route('superadmin.dimensions.index') }}">📐 Dimensions</a></li>
</ul>
@endsection

@section('content')
<div style="margin-bottom: 30px; display: flex; justify-content: space-between; align-items: center;">
    <div>
        <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Data Components</h1>
        <p style="color: var(--gray-600);">Kelola data komponen lain (Cleat, Support Drawer, dll)</p>
    </div>
    <a href="{{ route('superadmin.components.create') }}" class="btn btn-primary">+ Tambah Component</a>
</div>

@if(session('success'))
<div style="background: #d1fae5; border: 1px solid #86efac; padding: 12px 20px; border-radius: 8px; margin-bottom: 20px; color: #065f46;">
    {{ session('success') }}
</div>
@endif

<div class="grid grid-3">
    @forelse($components as $component)
    <div class="card" style="position: relative;">
        <!-- Badge Status -->
        <div style="position: absolute; top: 15px; right: 15px;">
            @if($component->is_active)
                <span style="background: #d1fae5; color: #065f46; padding: 4px 12px; border-radius: 12px; font-size: 11px; font-weight: 600;">Aktif</span>
            @else
                <span style="background: #fee2e2; color: #991b1b; padding: 4px 12px; border-radius: 12px; font-size: 11px; font-weight: 600;">Nonaktif</span>
            @endif
        </div>

        <!-- Icon -->
        <div style="width: 80px; height: 80px; background: #e0e7ff; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 15px;">
            <span style="font-size: 40px;">🔧</span>
        </div>

        <h3 style="font-size: 18px; color: var(--gray-800); margin-bottom: 5px; text-align: center;">{{ $component->name }}</h3>
        <p style="color: var(--gray-600); font-size: 14px; text-align: center; margin-bottom: 15px;">
            Material: <strong>{{ $component->material }}</strong>
        </p>

        <!-- Harga -->
        <div style="background: var(--gray-50); padding: 12px; border-radius: 8px; margin-bottom: 10px;">
            <p style="font-size: 12px; color: var(--gray-600); margin-bottom: 5px;">Harga per {{ $component->unit }}</p>
            <p style="font-size: 20px; font-weight: 700; color: var(--primary-green);">Rp {{ number_format($component->price_per_unit, 0, ',', '.') }}</p>
        </div>

        @if($component->description)
        <p style="font-size: 13px; color: var(--gray-600); margin-bottom: 15px; text-align: center;">{{ Str::limit($component->description, 60) }}</p>
        @endif

        <div style="display: flex; gap: 10px;">
            <a href="{{ route('superadmin.components.edit', $component->id) }}" class="btn btn-secondary" style="flex: 1; text-align: center; text-decoration: none;">Edit</a>
            <form action="{{ route('superadmin.components.destroy', $component->id) }}" method="POST" style="flex: 1;" onsubmit="return confirm('Yakin ingin menghapus component ini?')">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn" style="width: 100%; background: #ef4444; color: white;">Hapus</button>
            </form>
        </div>
    </div>
    @empty
    <div style="grid-column: 1 / -1; text-align: center; padding: 60px; color: var(--gray-500);">
        <div style="font-size: 64px; margin-bottom: 20px;">🔧</div>
        <p style="font-size: 18px; margin-bottom: 10px;">Belum ada data component</p>
        <a href="{{ route('superadmin.components.create') }}" style="color: var(--primary-green); font-weight: 600;">Tambah component pertama</a>
    </div>
    @endforelse
</div>

<div style="margin-top: 30px;">
    {{ $components->links() }}
</div>
@endsection