@extends('layouts.app')

@section('title', 'Tambah Component')

@section('sidebar')
<ul class="sidebar-menu">
    <li><a href="{{ route('superadmin.dashboard') }}">📊 Dashboard</a></li>
    <li><a href="{{ route('superadmin.buyers.index') }}">👥 Buyers</a></li>
    <li><a href="{{ route('superadmin.products.index') }}">📦 Products</a></li>
    <li><a href="{{ route('superadmin.materials.index') }}">🪵 Materials</a></li>
    <li><a href="{{ route('superadmin.veneers.index') }}">🎨 Veneers</a></li>
    <li><a href="{{ route('superadmin.components.index') }}" class="active">🔧 Components</a></li>
    <li><a href="{{ route('superadmin.dimensions.index') }}">📐 Dimensions</a></li>
</ul>
@endsection

@section('content')
<div style="margin-bottom: 30px;">
    <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Tambah Component Baru</h1>
    <p style="color: var(--gray-600);">Isi form di bawah untuk menambah component</p>
</div>

<div class="card" style="max-width: 800px;">
    <form action="{{ route('superadmin.components.store') }}" method="POST">
        @csrf

        <div class="form-group">
            <label for="name">Nama Component *</label>
            <input type="text" id="name" name="name" class="form-control" value="{{ old('name') }}" placeholder="Contoh: Cleat, Support Drawer" required>
            @error('name')
                <span class="error-message">{{ $message }}</span>
            @enderror
        </div>

        <div class="form-group">
            <label for="material">Material *</label>
            <input type="text" id="material" name="material" class="form-control" value="{{ old('material') }}" placeholder="Contoh: MAHONI, WALNUT" required>
            @error('material')
                <span class="error-message">{{ $message }}</span>
            @enderror
        </div>

        <div class="grid grid-2" style="gap: 20px;">
            <div class="form-group">
                <label for="price_per_unit">Harga per Unit (Rp) *</label>
                <input type="number" id="price_per_unit" name="price_per_unit" class="form-control" value="{{ old('price_per_unit') }}" step="0.01" placeholder="0" required>
                @error('price_per_unit')
                    <span class="error-message">{{ $message }}</span>
                @enderror
            </div>

            <div class="form-group">
                <label for="unit">Satuan *</label>
                <select id="unit" name="unit" class="form-control" required>
                    <option value="pcs" {{ old('unit') == 'pcs' ? 'selected' : '' }}>Pcs (Pieces)</option>
                    <option value="set" {{ old('unit') == 'set' ? 'selected' : '' }}>Set</option>
                    <option value="unit" {{ old('unit') == 'unit' ? 'selected' : '' }}>Unit</option>
                </select>
                @error('unit')
                    <span class="error-message">{{ $message }}</span>
                @enderror
            </div>
        </div>

        <div class="form-group">
            <label for="description">Deskripsi</label>
            <textarea id="description" name="description" class="form-control" rows="4" placeholder="Deskripsi component">{{ old('description') }}</textarea>
            @error('description')
                <span class="error-message">{{ $message }}</span>
            @enderror
        </div>

        <div class="form-group">
            <label style="display: flex; align-items: center; cursor: pointer;">
                <input type="checkbox" name="is_active" value="1" checked style="width: auto; margin-right: 8px;">
                <span>Status Aktif</span>
            </label>
        </div>

        <div style="display: flex; gap: 10px; margin-top: 30px;">
            <button type="submit" class="btn btn-primary">Simpan</button>
            <a href="{{ route('superadmin.components.index') }}" class="btn btn-secondary">Batal</a>
        </div>
    </form>
</div>
@endsection

@push('styles')
<style>
    .form-group {
        margin-bottom: 20px;
    }

    .form-group label {
        display: block;
        margin-bottom: 8px;
        color: var(--gray-700);
        font-weight: 600;
        font-size: 14px;
    }

    .error-message {
        color: #ef4444;
        font-size: 12px;
        margin-top: 5px;
        display: block;
    }

    select.form-control {
        cursor: pointer;
    }
</style>
@endpush