@extends('layouts.app')

@section('title', 'Pilih Product')

@section('sidebar')
<ul class="sidebar-menu">
    <li><a href="{{ route('admin.dashboard') }}">📊 Dashboard</a></li>
    <li><a href="{{ route('admin.quotations.create') }}" class="active">🛒 Pemesanan Baru</a></li>
    <li><a href="{{ route('admin.quotations.index') }}">📄 Riwayat Quotations</a></li>
</ul>
@endsection

@section('content')
<div style="margin-bottom: 30px;">
    <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Buat Quotation Baru</h1>
    <p style="color: var(--gray-600);">Step 2 dari 3: Pilih Product</p>
</div>

<!-- Progress Bar -->
<div style="background: var(--gray-200); height: 8px; border-radius: 4px; margin-bottom: 30px; overflow: hidden;">
    <div style="background: var(--primary-green); height: 100%; width: 66%;"></div>
</div>

<!-- Selected Buyer Info -->
<div class="card" style="margin-bottom: 30px; background: var(--primary-green-light); border: 2px solid var(--primary-green);">
    <div style="display: flex; align-items: center; gap: 15px;">
        <span style="font-size: 32px;">✓</span>
        <div>
            <p style="color: var(--gray-600); font-size: 14px; margin-bottom: 5px;">Buyer Terpilih:</p>
            <h3 style="font-size: 18px; color: var(--gray-800);">{{ $buyer->name }} ({{ $buyer->code }})</h3>
        </div>
    </div>
</div>

<form action="{{ route('admin.quotations.build-components') }}" method="POST">
    @csrf
    <input type="hidden" name="buyer_id" value="{{ $buyer->id }}">
    
    <h2 style="font-size: 20px; margin-bottom: 20px; color: var(--gray-800);">Pilih Product</h2>
    
    <div class="grid grid-3">
        @forelse($products as $product)
        <label class="card product-card" style="cursor: pointer; transition: all 0.3s ease;">
            <input type="radio" name="product_id" value="{{ $product->id }}" required style="display: none;" class="product-radio">
            
            @if($product->image)
                <img src="{{ asset('assets/images/products/' . $product->image) }}" alt="{{ $product->name }}" style="width: 100%; height: 180px; object-fit: cover; border-radius: 8px; margin-bottom: 15px;">
            @else
                <div style="width: 100%; height: 180px; background: var(--gray-200); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-bottom: 15px;">
                    <span style="font-size: 48px;">📦</span>
                </div>
            @endif
            
            <div class="checkmark-container" style="position: absolute; top: 15px; right: 15px; display: none;">
                <span class="checkmark">✓</span>
            </div>
            
            <h3 style="font-size: 18px; color: var(--gray-800); margin-bottom: 5px;">{{ $product->name }}</h3>
            <p style="color: var(--primary-green); font-weight: 600; font-size: 14px; margin-bottom: 10px;">{{ $product->code }}</p>
            
            @if($product->description)
            <p style="color: var(--gray-600); font-size: 13px;">{{ Str::limit($product->description, 80) }}</p>
            @endif
        </label>
        @empty
        <div style="grid-column: 1 / -1; text-align: center; padding: 60px; color: var(--gray-500);">
            <div style="font-size: 64px; margin-bottom: 20px;">📦</div>
            <p style="font-size: 18px;">Belum ada data product. Silakan hubungi SuperAdmin untuk menambahkan product.</p>
        </div>
        @endforelse
    </div>

    @if($products->count() > 0)
    <div style="margin-top: 30px; display: flex; gap: 10px;">
        <button type="submit" class="btn btn-primary" id="nextBtn" disabled>Lanjut ke Step 3 →</button>
        <a href="{{ route('admin.quotations.create') }}" class="btn btn-secondary">← Kembali</a>
    </div>
    @endif
</form>
@endsection

@push('styles')
<style>
    .product-card {
        position: relative;
        border: 2px solid transparent;
    }
    
    .product-card:hover {
        border-color: var(--primary-green);
        transform: translateY(-4px);
    }
    
    .product-card.selected {
        border-color: var(--primary-green);
        background: var(--primary-green-light);
    }
    
    .checkmark-container {
        background: var(--primary-green);
        width: 30px;
        height: 30px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .checkmark {
        color: white;
        font-size: 18px;
        font-weight: bold;
    }
</style>
@endpush

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const productCards = document.querySelectorAll('.product-card');
        const nextBtn = document.getElementById('nextBtn');
        
        productCards.forEach(card => {
            card.addEventListener('click', function() {
                // Remove selected class from all cards
                productCards.forEach(c => {
                    c.classList.remove('selected');
                    c.querySelector('.checkmark-container').style.display = 'none';
                });
                
                // Add selected class to clicked card
                this.classList.add('selected');
                this.querySelector('.checkmark-container').style.display = 'flex';
                
                // Check the radio button
                this.querySelector('.product-radio').checked = true;
                
                // Enable next button
                nextBtn.disabled = false;
            });
        });
    });
</script>
@endpush