<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Veneer;

class VeneerSeeder extends Seeder
{
    public function run(): void
    {
        $veneers = [
            // MAHONI
            ['name' => 'MAHONI', 'thickness' => 0.5, 'pattern' => 'lurus', 'price_per_m2' => 55000],
            ['name' => 'MAHONI', 'thickness' => 0.5, 'pattern' => 'motif', 'price_per_m2' => 135000],
            ['name' => 'MAHONI', 'thickness' => 0.6, 'pattern' => 'lurus', 'price_per_m2' => 60000],
            ['name' => 'MAHONI', 'thickness' => 0.6, 'pattern' => 'motif', 'price_per_m2' => 145000],
            
            // WALNUT
            ['name' => 'WALNUT', 'thickness' => 0.5, 'pattern' => 'lurus', 'price_per_m2' => 187000],
            ['name' => 'WALNUT', 'thickness' => 0.5, 'pattern' => 'motif', 'price_per_m2' => 350000],
            ['name' => 'WALNUT', 'thickness' => 0.6, 'pattern' => 'lurus', 'price_per_m2' => 200000],
            ['name' => 'WALNUT', 'thickness' => 0.6, 'pattern' => 'motif', 'price_per_m2' => 380000],
        ];

        foreach ($veneers as $veneer) {
            Veneer::create($veneer);
        }
    }
}