<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Product;

class ProductSeeder extends Seeder
{
    public function run(): void
    {
        $products = [
            [
                'name' => 'Meja Makan',
                'code' => 'MM-001',
                'description' => 'Meja makan kayu solid dengan finishing natural',
                'is_active' => true,
            ],
            [
                'name' => 'Kursi Kantor',
                'code' => 'KK-001',
                'description' => 'Kursi kantor ergonomis dengan busa premium',
                'is_active' => true,
            ],
            [
                'name' => 'Lemari Pakaian',
                'code' => 'LP-001',
                'description' => 'Lemari pakaian 3 pintu dengan laci',
                'is_active' => true,
            ],
            [
                'name' => 'Nightstand',
                'code' => 'NS-001',
                'description' => 'Montclaire 2 Drawer Nightstand',
                'is_active' => true,
            ],
        ];

        foreach ($products as $product) {
            Product::create($product);
        }
    }
}