<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Buyer;

class BuyerSeeder extends Seeder
{
    public function run(): void
    {
        $buyers = [
            [
                'name' => 'Ethan Allen',
                'code' => 'EA001',
                'address' => 'Danbury, Connecticut, USA',
                'phone' => '+1-203-743-8000',
                'email' => 'info@ethanallen.com',
                'is_active' => true,
            ],
            [
                'name' => 'Ashley Furniture',
                'code' => 'AF001',
                'address' => 'Arcadia, Wisconsin, USA',
                'phone' => '+1-608-323-3377',
                'email' => 'contact@ashleyfurniture.com',
                'is_active' => true,
            ],
            [
                'name' => 'IKEA',
                'code' => 'IK001',
                'address' => 'Älmhult, Sweden',
                'phone' => '+46-476-81000',
                'email' => 'info@ikea.com',
                'is_active' => true,
            ],
        ];

        foreach ($buyers as $buyer) {
            Buyer::create($buyer);
        }
    }
}