<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('component_dimensions', function (Blueprint $table) {
            $table->id();
            $table->decimal('value', 8, 2); // 10, 18, 40, 483, 660, dll
            $table->enum('type', ['lebar', 'panjang']); // Lebar atau Panjang
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('component_dimensions');
    }
};