<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('quotation_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('quotation_id')->constrained()->onDelete('cascade');
            $table->string('component_name'); // TOP PANEL, Patching Panel 1, dll
            $table->string('material_type')->nullable(); // PB, SOLID, VENEER, dll
            $table->decimal('length', 8, 2)->nullable(); // Panjang (mm)
            $table->decimal('width', 8, 2)->nullable(); // Lebar (mm)
            $table->decimal('thickness', 8, 2)->nullable(); // Tebal (mm)
            $table->decimal('m2', 10, 6)->nullable(); // Luas M2
            $table->integer('qty')->default(1); // Quantity
            $table->decimal('price_per_unit', 12, 2)->default(0); // Harga satuan
            $table->decimal('subtotal', 15, 2)->default(0); // Total harga komponen
            $table->string('note')->nullable(); // panjang x lebar, dll
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('quotation_details');
    }
};