<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('drawer_materials', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Mahoni (Front Drawer), dll
            $table->string('type'); // Front Drawer, Back Drawer, Side Drawer
            $table->decimal('length', 8, 2); // Panjang (L)
            $table->decimal('width', 8, 2); // Lebar (W)
            $table->decimal('m2', 10, 6); // Luas M2
            $table->decimal('price', 12, 2); // Harga
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('drawer_materials');
    }
};