<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DrawerMaterial extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'type',
        'length',
        'width',
        'm2',
        'price',
        'is_active',
    ];

    protected $casts = [
        'length' => 'decimal:2',
        'width' => 'decimal:2',
        'm2' => 'decimal:6',
        'price' => 'decimal:2',
        'is_active' => 'boolean',
    ];
}