<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Quotation;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        $data = [
            'myQuotations' => Quotation::where('user_id', Auth::id())->count(),
            'draftQuotations' => Quotation::where('user_id', Auth::id())->where('status', 'draft')->count(),
            'submittedQuotations' => Quotation::where('user_id', Auth::id())->where('status', 'submitted')->count(),
        ];

        return view('admin.dashboard', $data);
    }
}