
<?php $__env->startPush('styles'); ?>
<style>
    .sticky-table-wrapper {
        max-height: 1000px;
        overflow-y: auto;
        overflow-x: auto;
    }
    
    .sticky-table-wrapper [style*="min-width"]{ min-width:0 !important; }

    .sticky-table-wrapper table{
        width:auto;
        table-layout:auto;
    }
    
    .content-shell {
            max-width: 2150px;
    }

    .sticky-table-wrapper thead th {
        position: sticky;
        top: 0;
        background-color: #111111;
        color: white;
        z-index: 10;
        text-align: justify;
    }

    .sticky-table-wrapper input[type="checkbox"] {
        transform: scale(1.5); 
        margin: 0.3rem;
        cursor: pointer;
    }
    .sticky-table-wrapper td textarea {
        white-space: normal !important;
        min-width: 150px;
    }
    .sticky-table-wrapper tbody td,
    .sticky-table-wrapper tbody input,
    .sticky-table-wrapper tbody textarea,
    .sticky-table-wrapper tbody select {
        font-size: 15px;
        font-weight: bold;
    }
    .fit-content{
        width:auto !important;
        max-width:none !important;
        white-space:normal !important;
      }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    
    <div id="app">
        <div class="row mb-3">
            <div class="col-md-8">
                <h2>SKU Suggestion Mapping</h2>
            </div>
            <div class="col-md-4 d-flex justify-content-start">
                <form action="<?php echo e(route('refresh.MinMax.suggestions')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button class="btn btn-outline-primary">
                        <i class="bi bi-arrow-repeat me-1"></i> Refresh Cache
                    </button>
                </form>
            </div>
        </div>
        <div class="row mb-3">
            <div class="col-md-4">
                <div class="d-flex flex-wrap gap-2 mb-3">
                    <?php if(Str::contains(session('user')['email'] ?? '', ['Michael', 'adminbc'])): ?>
                        <button class="btn btn-primary" @click="uploadStockkeeping" :disabled="isSubmitting">
                            <i class="fas fa-upload me-1"></i> Upload Stockkeeping
                        </button>
                    <?php else: ?>
                    <button class="btn btn-success" @click="submitUpdates" :disabled="isSubmitting">
                        <i class="fas fa-save me-1"></i>
                        <span v-if="isSubmitting">Updating...</span>
                        <span v-else>Update SKU</span>
                    </button>
                    <?php endif; ?>
                    <button class="btn btn-outline-success" @click="exportToExcel" :disabled="isSubmitting">
                        <i class="fas fa-file-excel me-1"></i> Export to Excel
                    </button>
                    <button class="btn btn-outline-secondary" @click="resetAllRows" :disabled="isSubmitting">
                        <i class="fas fa-rotate-left me-1"></i> Undo All
                    </button>
                </div>
                <div class="mb-3">
                    <button class="btn btn-warning w-100" @click="applySuggestionToSelected" :disabled="isSubmitting">
                        <i class="fas fa-magic me-1"></i> Follow Suggestion
                    </button>
                </div>
                <div class="mb-3">
                      <button class="btn btn-primary w-100" @click="applyForecastToSelected" :disabled="isSubmitting">
                        <i class="fas fa-bolt me-1"></i> Follow Forecast
                      </button>
                </div>
            </div>
            <div class="col-md-4">
                <div class="mb-3">
                    <label for="locationFilter" class="form-label fw-bold">Filter by Location</label>
                    <select class="form-select w-auto d-inline" v-model="selectedLocation" id="locationFilter">
                        <option value="">All Locations</option>
                        <?php $__currentLoopData = $locationOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($location); ?>"><?php echo e($location); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="form-check mb-3">
                    <input class="form-check-input" type="checkbox" id="onlyModified" v-model="showOnlyModified">
                    <label class="form-check-label" for="onlyModified">
                        Show Only Modified Rows
                    </label>
                </div>
                <div class="form-check mb-3">
                    <input class="form-check-input" type="checkbox" id="onlySelected" v-model="showOnlySelected">
                    <label class="form-check-label" for="onlySelected">
                        Show Only Selected Rows
                    </label>
                </div>
            </div>
            <div class="col-md-4">
                <div class="mb-3">
                    <label for="searchText" class="form-label fw-bold">Search Item No / Name</label>
                    <input type="text" class="form-control form-control-sm" id="searchText" v-model="searchText" placeholder="Search...">
                </div>
                <div class="mb-3">
                    <label class="form-label fw-bold">Filter by Status</label>
                    <select class="form-select w-auto d-inline" v-model="statusFilter">
                        <option value="">All</option>
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                </div>
            </div>  
        </div>
        <div class="sticky-table-wrapper">
            <table class="table table-striped table-hover table-bordered align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th><input type="checkbox" v-model="selectAll" @change="toggleSelectAll"></th>
                            <th @click="sortBy('Item_No')" style="cursor:pointer">
                                No.
                                <span v-if="sortColumn === 'Item_No'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th @click="sortBy('Description')" style="cursor:pointer">
                                Desc.
                                <span v-if="sortColumn === 'Description'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th class="fit-content" @click="sortBy('Stock_For')" style="cursor:pointer">
                                Stock For <br> (Days)
                                <span v-if="sortColumn === 'Stock_For'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th class="fit-content" @click="sortBy('Lead Time')" style="cursor:pointer">
                                L.Time
                                <span v-if="sortColumn === 'Lead Time'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th class="fit-content" @click="sortBy('Consumption')" style="cursor:pointer">
                                Cons<br><small>2 Month</small>
                                <span v-if="sortColumn === 'Consumption'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th class="fit-content" @click="sortBy('SuggestMinQty')" style="cursor:pointer">
                                MinQty <br> <small>(Suggested)</small>
                                <span v-if="sortColumn === 'SuggestMinQty'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th class="fit-content" @click="sortBy('ActMinQty')" style="cursor:pointer">
                                MinQty <br> <small>(Temp)</small>
                                <span v-if="sortColumn === 'ActMinQty'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th class="fit-content" @click="sortBy('RealMinQty')" style="cursor:pointer">
                                MinQty <br> <small>(Actual)</small>
                                <span v-if="sortColumn === 'RealMinQty'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th class="fit-content" @click="sortBy('ForecMin_Avg')" style="cursor:pointer">
                                MinQty <br> <small>(Forecast)</small>
                                <span v-if="sortColumn === 'ForecMin_Avg'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th class="fit-content" @click="sortBy('SuggestMaxQty')" style="cursor:pointer">
                                MaxQty <br> <small>(Suggested)</small>
                                <span v-if="sortColumn === 'SuggestMaxQty'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th class="fit-content" @click="sortBy('ActMaxQty')" style="cursor:pointer">
                                MaxQty <br> <small>(Temp)</small>
                                <span v-if="sortColumn === 'ActMaxQty'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th class="fit-content" @click="sortBy('RealMaxQty')" style="cursor:pointer">
                                MaxQty <br> <small>(Actual)</small>
                                <span v-if="sortColumn === 'RealMaxQty'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th class="fit-content" @click="sortBy('ForecMax_Avg')" style="cursor:pointer">
                                MaxQty <br> <small>(Forecast)</small>
                                <span v-if="sortColumn === 'ForecMax_Avg'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                            <th>Reset</th>
                            <th>Action</th>
                            <th style="min-width: 150px;">Comment</th>
                            <th @click="sortBy('LastModifiedAt')" style="cursor:pointer">
                                Modified At
                                <span v-if="sortColumn === 'LastModifiedAt'">
                                    <i :class="sortDirection === 'asc' ? 'fas fa-arrow-up' : 'fas fa-arrow-down'"></i>
                                </span>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr v-for="(row, index) in filteredRows" :key="index" :class="{ 'table-danger': isRowModified(row) }">
                            <td> <input type="checkbox" v-model="row.selected"></td>
                            <td><strong>{{ row.Item_No }}</strong></td>
                            <td>{{ row.Description }}</td>
                            <td>
                            <input type="number"
                                    class="form-control form-control-sm"
                                    v-model.number="row['Stock_For']"
                                    @input="updateSuggestions(row)">
                            </td>
                            <td>
                            <input type="number"
                                    class="form-control form-control-sm"
                                    v-model.number="row['Lead Time']"
                                    @input="updateSuggestions(row)">
                            </td>                            
                            <td>{{ formatNumber(row['Consumption']) }}</td>
                            <td class="text-primary">{{ formatNumber(row.SuggestMinQty) }}</td>
                            <td><input type="number" class="form-control form-control-sm" v-model.number="row.ActMinQty"></td>
                            <td class="text-success">{{ formatNumber(row.RealMinQty) }}</td>
                            <td>
                                <template v-if="isRegentEnv">
                                    
                                    <div class="text-muted"><small>Regent</small> {{ formatNumber(row.ForecMin_RBC ?? 0) }}</div>
                                    <div class="text-success"><small>Avg</small> {{ formatNumber((row.ForecMin_Avg ?? row.ForecMin) ?? 0) }}</div>
                                </template>
                                <template v-else>
                                    <span class="text-success">{{ formatNumber((row.ForecMin_Avg ?? row.ForecMin) ?? 0) }}</span>
                                </template>
                            </td>
                            <td class="text-primary">{{ formatNumber(row.SuggestMaxQty) }}</td>
                            <td><input type="number" class="form-control form-control-sm" v-model.number="row.ActMaxQty"></td>
                            <td class="text-success">{{ formatNumber(row.RealMaxQty) }}</td>
                            <td>
                                <template v-if="isRegentEnv">
                                    
                                    <div class="text-muted"><small>Regent</small> {{ formatNumber(row.ForecMax_RBC ?? 0) }}</div>
                                    <div class="text-success"><small>Avg</small> {{ formatNumber((row.ForecMax_Avg ?? row.ForecMax) ?? 0) }}</div>
                                </template>
                                <template v-else>
                                    <span class="text-success">{{ formatNumber((row.ForecMax_Avg ?? row.ForecMax) ?? 0) }}</span>
                                </template>
                            </td>
                            <td>
                                <button class="btn btn-sm btn-outline-secondary" @click="resetRow(row)">
                                    <i class="fas fa-undo"></i> Reset
                                </button>
                            </td>
                            <td >
                                <div class="d-flex flex-column flex-md-row gap-1">
                                    <button
                                            class="btn btn-sm btn-warning"
                                            :disabled="isSubmitting"
                                            @click="applySuggestionToRow(row)">
                                            <i class="fas fa-magic me-1"></i> Suggest
                                    </button>
                                    <button
                                      class="btn btn-sm btn-primary"
                                      :disabled="isSubmitting"
                                      @click="applyForecastToRow(row)">
                                      <i class="fas fa-bolt me-1"></i> Forecast
                                    </button>

                                    <?php
                                        $email = strtolower(session('user')['email'] ?? '');
                                    ?>

                                    <?php if(Str::contains($email, ['michael', 'adminbc'])): ?>
                                        <button
                                            class="btn btn-sm btn-primary"
                                            :disabled="isSubmitting"
                                            @click="uploadStockkeepingRow(row)">
                                            <i class="fas fa-upload me-1"></i> Upload
                                        </button>
                                    <?php else: ?>
                                        <button
                                            class="btn btn-sm btn-success"
                                            :disabled="isSubmitting"
                                            @click="saveSingleRow(row)">
                                            <i class="fas fa-save me-1"></i> Save
                                        </button>
                                        
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td style="min-width: 150px; white-space: normal;">
                                <textarea class="form-control form-control-sm" rows="3" v-model="row['Comment']"></textarea>
                            </td>
                            <td>
                                {{ row.LastModifiedAt }}
                            </td>
                        </tr>
                    </tbody>
                </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script>
    $(document).ready(function () {
        $('#sku-table').DataTable({
            pageLength: 25,
            order: [[ 0, 'asc' ]],
            responsive: true,
            language: {
                search: "_INPUT_",
                searchPlaceholder: "Search Item No or Qty..."
            }
        });
    });
</script>

<script>
const { createApp } = Vue;

<?php
    $activeCompany = session('current_company_name', session('user')['role'] ?? '');
    $isRegentEnv = in_array($activeCompany, ['Regent','SUPER'], true);
?>

createApp({
    data() {
        return {
            rows: <?php echo json_encode($result, 15, 512) ?>,
            isSubmitting: false,
            selectedLocation: '',
            showOnlyModified: false,
            selectAll: false,
            searchText: '',
            showOnlySelected: false,
            sortColumn: '',
            sortDirection: 'asc',
            statusFilter: '',
            isRegentEnv: <?php echo json_encode($isRegentEnv, 15, 512) ?>,
        };
    },
    computed: {
    filteredRows() {
        let result = this.rows.filter(row => {
            const desc = row.Description?.toUpperCase() || '';
            if (desc.includes('FRUIT & VEGETABLE') || desc.includes('MEAT - ')) {
                return false;
            }
            const matchesLocation = this.selectedLocation === '' || row.Location === this.selectedLocation;

            const search = this.searchText.toLowerCase();
            const matchesSearch =
                this.searchText === '' ||
                row.Item_No.toLowerCase().includes(search) ||
                row.Description.toLowerCase().includes(search);

            const isSelected = !this.showOnlySelected || row.selected;

            const original = row.original || {};
            const isModified =
                row.Stock_For !== original.Stock_For ||
                row['Lead Time'] !== original['Lead Time'] ||
                row.ActMinQty !== row.RealMinQty ||
                row.ActMaxQty !== row.RealMaxQty;
            const isActive = !(Number(row['Consumption']) === 0);

            const matchesStatus =
                this.statusFilter === '' ||
                (this.statusFilter === 'active' && isActive) ||
                (this.statusFilter === 'inactive' && !isActive);

            if (this.showOnlyModified) {
                return matchesLocation && matchesSearch && isModified && isSelected & matchesStatus;
            }

            return matchesLocation && matchesSearch && isSelected & matchesStatus;
        });

        // if (this.sortColumn) {
        //     result.sort((a, b) => {
        //         const valA = a[this.sortColumn] ?? '';
        //         const valB = b[this.sortColumn] ?? '';
        //         const direction = this.sortDirection === 'asc' ? 1 : -1;

        //         if (typeof valA === 'number' && typeof valB === 'number') {
        //             return (valA - valB) * direction;
        //         }

        //         return valA.toString().localeCompare(valB.toString()) * direction;
        //     });
        // }

        return result;
    }


        },
            methods: {
                exportToExcel() {
                    const params = new URLSearchParams();

                    if (this.selectedLocation) params.set('location', this.selectedLocation);
                    if (this.searchText)       params.set('search', this.searchText);
                    if (this.statusFilter)     params.set('status', this.statusFilter); // 'active' | 'inactive'

                    const selectedKeys = this.rows
                        .filter(r => this.showOnlySelected ? r.selected : true) 
                        .filter(r => r.Item_No && r.Location)
                        .map(r => `${r.Item_No}|${r.Location}`);


                    if (this.showOnlySelected) {
                        if (!selectedKeys.length) {
                        alert('No selected rows to export.');
                        return;
                        }
                        selectedKeys.forEach(k => params.append('selected[]', k));
                    }

                    const url = `<?php echo e(route('sku.mapping.export')); ?>?${params.toString()}`;
                    window.location.href = url;
                    },
                parseDate(str) {
                    const months = {
                        january: 0, february: 1, march: 2, april: 3,
                        may: 4, june: 5, july: 6, august: 7,
                        september: 8, october: 9, november: 10, december: 11
                    };

                    if (!str) return null;

                    const parts = str.trim().split(' ');
                    if (parts.length !== 3) return null;

                    const day = parseInt(parts[0], 10);
                    const month = months[parts[1].toLowerCase()];
                    const year = parseInt(parts[2], 10);

                    return new Date(year, month, day);
                },
                getForecastMin(row) {
                  const v = (row.ForecMin_Avg ?? row.ForecMin);
                  return (typeof v === 'number' && isFinite(v)) ? v : 0;
                },
                getForecastMax(row) {
                  const v = (row.ForecMax_Avg ?? row.ForecMax);
                  return (typeof v === 'number' && isFinite(v)) ? v : 0;
                },
                
                applyForecast(row) {
                  row.ActMinQty = Math.ceil(this.getForecastMin(row));
                  row.ActMaxQty = Math.ceil(this.getForecastMax(row));
                },
                
                applyForecastToRow(row) {
                  this.applyForecast(row);
                },
                
                applyForecastToSelected() {
                  this.rows.forEach(r => {
                    if (r.selected) this.applyForecast(r);
                  });
                },
                uploadStockkeepingRow(row) {
                    if (this.isSubmitting) return; 

                    // if (!this.isRowModified(row)) {
                    //     alert('No changes detected. Row will not be uploaded.');
                    //     return;
                    // }
                    this.isSubmitting = true;

                    axios.post('<?php echo e(route("api.stockkeeping.upload")); ?>', {
                        rows: [row]
                    })
                    .then(response => {
                        alert(response.data.message || 'Stockkeeping uploaded successfully.');
                        this.updateSuggestions(row);
                        row.RealMinQty = row.ActMinQty;
                        row.RealMaxQty = row.ActMaxQty;
                        Object.assign(row.original, JSON.parse(JSON.stringify(row)));
                        row.selected = false;
                    })
                    .catch(error => {
                        console.error(error);
                        alert('Upload failed. See console for details.');
                    })
                    .finally(() => {
                        this.isSubmitting = false;
                    });
                },
                applySuggestionToRow(row) {
                    row.ActMinQty = row.SuggestMinQty;
                    row.ActMaxQty = row.SuggestMaxQty;
                },
                saveSingleRow(row) {
                    this.isSubmitting = true;

                    axios.post('<?php echo e(route("sku.update")); ?>', {
                        rows: [row]  
                    })
                    .then(response => {
                        this.updateSuggestions(row);
                        Object.assign(row.original, JSON.parse(JSON.stringify(row)));
                        row.selected = false;
                    })
                    .catch(error => {
                        console.error(error);
                        alert('Row update failed. See console/logs.');
                    })
                    .finally(() => {
                        this.isSubmitting = false;
                    });
                },

                applySuggestionToSelected() {
                    this.rows.forEach(row => {
                        if (row.selected) {
                            row.ActMinQty = row.SuggestMinQty;
                            row.ActMaxQty = row.SuggestMaxQty;
                        }
                    });
                },
        toggleSelectAll() {
            this.filteredRows.forEach(row => {
                row.selected = this.selectAll;
            });
        },
        updateSuggestions(row) {
            const consumption = row['Consumption / 2 months'] ?? 0;
            const stockFor = row['Stock_For'] || 0;
            const leadTime = row['Lead Time'] || 0;
            const avg_up = row['avg_rn'] || 0;
            row.Consumption = consumption;
            row.SuggestMinQty = Math.ceil((leadTime + 1) * (consumption / 60));
            row.SuggestMaxQty = Math.ceil(stockFor * (consumption / 60));
            const setPref = (preferKey, fallbackKey, value) => {
            if (Object.prototype.hasOwnProperty.call(row, preferKey)) row[preferKey] = value;
            else row[fallbackKey] = value;
          };
        
          if (avg_up > 0) {
            setPref('ForecMin_Avg', 'ForecMin', Math.ceil(row.SuggestMinQty * avg_up));
            setPref('ForecMax_Avg', 'ForecMax', Math.ceil(row.SuggestMaxQty * avg_up));
          }
        },
        formatNumber(value) {
            return new Intl.NumberFormat().format(value ?? 0);
        },
        isRowModified(row) {
            const original = row.original ?? {};

            const diffPercent = (newVal, oldVal) => {
                if (typeof newVal !== 'number' || typeof oldVal !== 'number') return false;
                if (oldVal === 0) return newVal !== 0; // avoid divide-by-zero
                return Math.abs((newVal - oldVal) / oldVal) > 0.05; // > 5%
            };

            return (
                row['Stock_For'] !== original['Stock_For'] ||
                row['Lead Time'] !== original['Lead Time'] ||
                diffPercent(row.ActMinQty, original.ActMinQty) ||
                diffPercent(row.ActMaxQty, original.ActMaxQty) ||
                row.Comment !== original.Comment
            );
        },
        resetRow(row) {
            const original = JSON.parse(JSON.stringify(row.original));
            Object.keys(original).forEach(key => {
                if (key !== 'original') row[key] = original[key];
            });
            row.selected = false;
        },

        resetAllRows() {
            this.rows.forEach(row => {
                const original = JSON.parse(JSON.stringify(row.original));
                Object.keys(original).forEach(key => {
                    if (key !== 'original') row[key] = original[key];
                });
                row.selected = false;
            });
        },
        today() {
            return new Date().toISOString(); 
        },
        async uploadStockkeeping() {
          if (this.isSubmitting) return;
          this.isSubmitting = true;
        
          const selectedRows = this.rows.filter(r => r.selected);
          if (!selectedRows.length) {
            alert('Please select at least one row to upload.');
            this.isSubmitting = false;
            return;
          }
        
          // 1) Sanitize "entire row": drop UI/internal fields, coerce types, trim long text
          const sanitizeRow = (r) => {
            const x = JSON.parse(JSON.stringify(r));   // strips proxies/functions
        
            // blacklist UI/internal keys
            delete x.selected;
            delete x.original;
        
            // (optional) drop purely derived fields if your API doesn’t need them
            // delete x.SuggestMinQty; delete x.SuggestMaxQty;
            // delete x.ForecMin_Avg; delete x.ForecMax_Avg;
            // delete x.ForecMin_HIC; delete x.ForecMin_RBC;
            // delete x.ForecMax_HIC; delete x.ForecMax_RBC;
        
            // normalize types expected by backend/DB
            const toInt = v => Number.isFinite(+v) ? Math.round(+v) : 0;
            x.ActMinQty = toInt(x.ActMinQty);
            x.ActMaxQty = toInt(x.ActMaxQty);
            x['Stock_For'] = toInt(x['Stock_For']);
            x['Lead Time'] = toInt(x['Lead Time']);
        
            // (optional) clip comment to avoid SQL “string too long”
            if (typeof x.Comment === 'string') x.Comment = x.Comment.slice(0, 250);
        
            // (optional) standardize date
            if (x.LastModifiedAt && typeof x.LastModifiedAt === 'string') {
              // keep as-is or convert to ISO
              // x.LastModifiedAt = new Date(x.LastModifiedAt).toISOString();
            }
        
            return x;
          };
        
          const rowsToSend = selectedRows.map(sanitizeRow);
        
          const BATCH_SIZE = 50;                   // 50 or 20 is fine
          const token = document.querySelector('meta[name="csrf-token"]')?.content;
        
          // 2) Helper that posts one batch and surfaces server text/JSON nicely
          const postBatch = async (slice, batchIdx) => {
            try {
              await axios.post('<?php echo e(route("api.stockkeeping.upload")); ?>',
                { rows: slice },
                {
                  headers: {
                    'Content-Type': 'application/json',
                    'Accept': 'application/json',
                    ...(token ? { 'X-CSRF-TOKEN': token } : {}),
                  }
                }
              );
            } catch (err) {
              // If 500, show which batch and one example row key to help locating it
              const sample = slice[0] || {};
              const payloadPreview = `${sample.Item_No || ''} @ ${sample.Location || ''}`;
              const body = typeof err?.response?.data === 'string'
                ? err.response.data
                : JSON.stringify(err?.response?.data || {}, null, 2);
              console.error('Batch failed:', { batchIdx, payloadPreview, error: err.response || err });
              alert(`Upload failed on batch #${batchIdx + 1} (e.g. ${payloadPreview}).\n` +
                    `Status: ${err?.response?.status || 'N/A'}\n` +
                    `${body.substring(0, 500)}${body.length > 500 ? '…' : ''}`);
              throw err; // stop further batches
            }
          };
        
          try {
            for (let i = 0, b = 0; i < rowsToSend.length; i += BATCH_SIZE, b++) {
              const slice = rowsToSend.slice(i, i + BATCH_SIZE);
              try {
                await postBatch(slice, b);
              } catch {
                for (let j = 0; j < slice.length; j++) {
                  try {
                    await postBatch([slice[j]], b); // send one-by-one to find the culprit
                  } catch {
                    const r = slice[j];
                    alert(`❌ Row failed: ${r.Item_No || ''} @ ${r.Location || ''}`);
                    throw new Error('Stopped after identifying failing row');
                  }
                }
              }
            }
        
            alert('Stockkeeping uploaded successfully.');
        
            selectedRows.forEach(row => {
              this.updateSuggestions(row);
              row.RealMinQty = row.ActMinQty;
              row.RealMaxQty = row.ActMaxQty;
              row.LastModifiedAt = this.today();
              row.original = {
                Item_No: row.Item_No,
                Description: row.Description,
                Location: row.Location,
                Stock_For: row['Stock_For'],
                'Lead Time': row['Lead Time'],
                ActMinQty: row.ActMinQty,
                ActMaxQty: row.ActMaxQty,
                RealMinQty: row.RealMinQty,
                RealMaxQty: row.RealMaxQty,
                Comment: row.Comment,
                LastModifiedAt: row.LastModifiedAt,
              };
              row.selected = false;
            });
        
          } catch (e) {
          } finally {
            this.isSubmitting = false;
          }
        },
        // uploadStockkeeping() {
        //             this.isSubmitting = true;
        
        //             const selectedRows = this.rows.filter(row => row.selected);
        
        //             if (selectedRows.length === 0) {
        //                 alert('Please select at least one row to upload.');
        //                 this.isSubmitting = false;
        //                 return;
        //             }
        
        //             const modifiedRows = selectedRows.filter(row => this.isRowModified(row));
        
        //             // if (modifiedRows.length === 0) {
        //             //    alert('No selected rows have changes greater than 5% (ActMinQty/ActMaxQty) or other edited fields.');
        //             //    this.isSubmitting = false;
        //             //    return;
        //             //}
        
        //             axios.post('<?php echo e(route("api.stockkeeping.upload")); ?>', {
        //                 rows: selectedRows
        //             })
        //             .then(response => {
        //                 alert(response.data.message || 'Stockkeeping uploaded successfully.');
        //                 selectedRows.forEach(row => {
        //                     this.updateSuggestions(row);
        //                     row.RealMinQty = row.ActMinQty;
        //                     row.RealMaxQty = row.ActMaxQty;
        //                     row.LastModifiedAt = this.today();
        //                     Object.assign(row.original, JSON.parse(JSON.stringify(row)));;
        //                     row.selected = false;
        //                 });
        //             })
        //             .catch(error => {
        //                 if (error.response) {
        //                     console.error("Response error:", error.response);
        //                     alert(`Upload failed: ${error.response.status} - ${error.response.data?.message || 'Server error'}`);
        //                 } else if (error.request) {
        //                     console.error("No response received:", error.request);
        //                     alert('Upload failed: No response from server.');
        //                 } else {
        //                     console.error("Axios error:", error.message);
        //                     alert('Upload failed: ' + error.message);
        //                 }
        //             })
        //             .finally(() => {
        //                 this.isSubmitting = false;
        //             });
        //         },
        submitUpdates() {
            this.isSubmitting = true;

            const modifiedRows = this.rows.filter(row =>
                this.isRowModified(row) && row.selected
            );

            if (modifiedRows.length === 0) {
                alert('No changes to update.');
                this.isSubmitting = false;
                return;
            }

            axios.post('<?php echo e(route("sku.update")); ?>', {
                rows: modifiedRows
            })
            .then(response => {
                alert(response.data.message || 'Update success');
                modifiedRows.forEach(row => {
                    this.updateSuggestions(row);
                    Object.assign(row.original, JSON.parse(JSON.stringify(row)));;
                    row.selected = false;
                });
            })
            .catch(error => {
                console.error(error);
                alert('Update failed. Check console or logs.');
            })
            .finally(() => {
                this.isSubmitting = false;
            });
        },  
       sortBy(column) {
            if (this.sortColumn === column) {
                this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
            } else {
                this.sortColumn = column;
                this.sortDirection = 'asc';
            }
            const direction = this.sortDirection === 'asc' ? 1 : -1;
            const parseDate = (str) => {
                if (!str) return null;
                const parts = str.trim().split(' ');
                if (parts.length !== 3) return null;
                const day = parseInt(parts[0], 10);
                const month = new Date(`${parts[1]} 1, 2000`).getMonth(); 
                const year = parseInt(parts[2], 10);
                return new Date(year, month, day);
            };
            count = 0
            this.rows.sort((a, b) => {
                const valA = a[column];
                const valB = b[column];
                if (column == 'LastModifiedAt') {
                    const dateA = parseDate(valA);
                    const dateB = parseDate(valB);

                    if (!dateA || !dateB || isNaN(dateA) || isNaN(dateB)) return 0;
                    if (count < 100 && dateA != dateB){
                        console.log(a.Description, 'Val A' , dateA.getTime());
                        console.log(b.Description, 'Val B' , dateB.getTime());
                        console.log((dateA.getTime() - dateB.getTime()) * direction);
                    }
                    count += 1;

                    return (dateA.getTime() - dateB.getTime()) * direction;
                }

                if (typeof valA === 'number' && typeof valB === 'number') {
                    return (valA - valB) * direction;
                }

                
                return valA.toString().localeCompare(valB.toString()) * direction;
            });
        }

    },
    mounted() {
        const test = "03 May 2024";
        const parsed = this.parseDate(test);
        console.log("Parsed:", parsed);
        this.rows.forEach(row => {
            this.updateSuggestions(row);
            row.selected = false;
            row.original = JSON.parse(JSON.stringify(row));
        });
    }
}).mount('#app');
</script>
<script>
  axios.defaults.withCredentials = true;
  axios.defaults.headers.common['X-Requested-With'] = 'XMLHttpRequest';

  // attach token from meta
  axios.interceptors.request.use(cfg => {
    const t = document.querySelector('meta[name="csrf-token"]')?.content;
    if (t) cfg.headers['X-CSRF-TOKEN'] = t;
    return cfg;
  });

  // on 419, refresh token and retry once
  axios.interceptors.response.use(r => r, async err => {
    const cfg = err.config || {};
    if (err.response?.status === 419 && !cfg.__retried) {
      try {
        const { data } = await axios.get('<?php echo e(route('csrf.refresh')); ?>', { withCredentials: true });
        const t = data?.token;
        if (t) {
          document.querySelector('meta[name="csrf-token"]').setAttribute('content', t);
          cfg.headers = cfg.headers || {};
          cfg.headers['X-CSRF-TOKEN'] = t;
          cfg.__retried = true;
          return axios(cfg);
        }
      } catch {}
      // fallback: send to login if refresh fails
      window.location.href = '<?php echo e(route('login')); ?>';
    }
    return Promise.reject(err);
  });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\jimmy\Documents\hotelstocks\resources\views/sku-mapping.blade.php ENDPATH**/ ?>