<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Business Central Dashboard')</title>

    <!-- Bootstrap & Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- Vue & Axios (keep if you use them) -->
    <script src="https://unpkg.com/vue@3"></script>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/echarts@5/dist/echarts.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/echarts-liquidfill@3/dist/echarts-liquidfill.min.js"></script>
    <script src="https://unpkg.com/pdf-lib/dist/pdf-lib.min.js"></script>

    <!-- Alpine (once) -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://unpkg.com/@alpinejs/collapse@3.x.x/dist/cdn.min.js" defer></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('form').forEach(form => {
                const oldData = {};
                form.querySelectorAll('input, select, textarea').forEach(el => {
                    if (el.name) {
                        if (el.type === 'checkbox' || el.type === 'radio') {
                            oldData[el.name] = el.checked ? el.value : '';
                        } else if (el.files && el.files.length) {
                            oldData[el.name] = Array.from(el.files).map(f => f.name);
                        } else {
                            oldData[el.name] = el.value;
                        }
                    }
                });

                const input = document.createElement('input');
                input.type = 'hidden';
                input.name = '_old_data';
                input.value = JSON.stringify(oldData);
                form.appendChild(input);
            });
        });
    </script>
    <style>
        :root {
            --brand-start: #0d6efd;
            /* primary */
            --brand-end: #20c997;
            /* teal */
        }

        .navbar-gradient {
            background: linear-gradient(135deg, var(--brand-start), var(--brand-end));
        }

        .navbar .nav-link {
            border-radius: 999px;
            padding: .45rem .9rem;
            transition: background-color .15s ease, color .15s ease, transform .06s ease-in;
        }

        .navbar .nav-link:hover {
            background: rgba(255, 255, 255, .12);
        }

        .nav-link.active,
        .nav-link.nav-link-active {
            background: rgba(255, 255, 255, .22);
            color: #fff !important;
            font-weight: 600;
        }

        .dropdown-menu {
            border-radius: .8rem;
            border: 1px solid rgba(0, 0, 0, .05);
            box-shadow: 0 10px 30px rgba(0, 0, 0, .08);
        }

        .chip-role {
            font-size: .75rem;
            padding: .15rem .5rem;
            border-radius: 999px;
            background: rgba(255, 255, 255, .18);
        }

        .content-shell {
            max-width: 1320px;
        }

        .card-soft {
            border-radius: 1rem;
            border: 1px solid rgba(0, 0, 0, .06);
            box-shadow: 0 8px 24px rgba(0, 0, 0, .05);
        }

        .breadcrumb {
            --bs-breadcrumb-divider-color: currentColor;
            --bs-breadcrumb-item-active-color: inherit;
        }

        [data-theme="dark"] .dropdown-menu {
            background: #1f2937;
            border-color: rgba(255, 255, 255, .08);
        }

        [data-theme="dark"] .dropdown-item {
            color: #e5e7eb;
        }

        [data-theme="dark"] .dropdown-item:hover {
            background: rgba(255, 255, 255, .06);
        }

        /* Toast slot sits fixed bottom-right */
        .toast-slot {
            position: fixed;
            right: 1rem;
            bottom: 1rem;
            z-index: 1080;
        }
    </style>

    @stack('styles')
</head>

<body x-data="theme()" x-init="init()" :data-theme="mode"
    :class="mode === 'dark' ? 'bg-dark text-light' : 'bg-light text-dark'">
    <nav class="navbar navbar-expand-lg navbar-dark navbar-gradient shadow-sm sticky-top">
        <div class="container-fluid content-shell">

            <!-- Brand / Logo -->
            <a class="navbar-brand fw-semibold d-flex align-items-center gap-2" href="/">
                <i class="fa-solid fa-boxes-stacked"></i>
                <span>Oultet Order</span>
            </a>

            <!-- Mobile toggle -->
            <button class="navbar-toggler border-0" type="button" data-bs-toggle="collapse"
                data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false"
                aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarNav">

                <!-- LEFT: Main navigation -->
                <ul class="navbar-nav me-auto gap-lg-1">
                    <!-- <li class="nav-item">
                        <a class="nav-link d-flex align-items-center gap-2 active" href="/dashboard">
                            <i class="fa-solid fa-chart-line"></i>
                            <span>Dashboard</span>
                        </a>
                    </li> -->

                    <li class="nav-item">
                        <a class="nav-link d-flex align-items-center gap-2"
                        href="{{ route('po-suggestions') }}">
                            <i class="fa-solid fa-file-invoice"></i>
                            <span>Purchase Orders</span>
                        </a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link d-flex align-items-center gap-2"
                        href="{{ route('sku-mapping') }}">
                            <i class="fa-solid fa-warehouse"></i>
                            <span>Stockkeeping</span>
                        </a>
                    </li>
                </ul>

                <!-- RIGHT: Controls -->
                <ul class="navbar-nav align-items-center gap-2">

                    <!-- Theme toggle -->
                    <li class="nav-item">
                        <button class="btn btn-sm btn-outline-light d-flex align-items-center gap-2"
                            @click="toggle()"
                            :aria-label="mode === 'dark' ? 'Switch to light mode' : 'Switch to dark mode'">
                            <i :class="mode === 'dark' ? 'fa-solid fa-sun' : 'fa-solid fa-moon'"></i>
                            <span class="d-none d-md-inline"
                                x-text="mode === 'dark' ? 'Light' : 'Dark'"></span>
                        </button>
                    </li>

                    <!-- Company -->
                    <li class="nav-item">
                        <span class="nav-link d-flex align-items-center gap-2 small opacity-75">
                            <i class="fa-solid fa-building"></i>
                            {{ session('current_company_name', data_get(session('user'), 'role')) }}
                        </span>
                    </li>

                    <!-- User -->
                    @if (session('user'))
                        <li class="nav-item d-flex align-items-center gap-2 ps-lg-2 border-start border-light border-opacity-25">
                            <i class="fa-solid fa-user-circle"></i>
                            <span class="fw-semibold small">
                                {{ data_get(session('user'), 'email') }}
                            </span>
                        </li>
                    @endif

                </ul>
            </div>
        </div>
    </nav>

    <header class="py-3">
        <div class="container content-shell">
            @hasSection('breadcrumb')
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-2">
                        @yield('breadcrumb')
                    </ol>
                </nav>
            @endif

            @if (session('status'))
                <div class="alert alert-success card-soft mb-0">
                    <i class="fa-solid fa-circle-check me-2"></i> {{ session('status') }}
                </div>
            @endif
        </div>
    </header>

    <!-- CONTENT -->
    <main class="py-3 py-md-4">
        <div class="container content-shell">
            @yield('content')
        </div>
    </main>

    <!-- Toast slot -->
    <div class="toast-slot">
        @stack('toasts')
    </div>

    <!-- FOOTER -->
    <footer class="py-4 border-top">
        <div class="container content-shell d-flex justify-content-between small text-muted">
            <span>&copy; {{ now()->year }} — Butcher Portal</span>
            <span>v{{ config('app.version', '1.0') }}</span>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function theme() {
            return {
                mode: localStorage.getItem('theme') || 'light',
                init() {
                    this.apply();
                },
                toggle() {
                    this.mode = this.mode === 'light' ? 'dark' : 'light';
                    localStorage.setItem('theme', this.mode);
                    this.apply();
                },
                apply() {
                    document.documentElement.setAttribute('data-theme', this.mode);
                    document.body.classList.toggle('bg-dark', this.mode === 'dark');
                    document.body.classList.toggle('text-light', this.mode === 'dark');
                    document.body.classList.toggle('bg-light', this.mode === 'light');
                    document.body.classList.toggle('text-dark', this.mode === 'light');
                }
            }
        }
    </script>

    @stack('scripts')
    @stack('vendor-edit-scripts')
</body>

</html>
