@extends('layouts.app')
@section('title','My Approvals')

@push('styles')
<style>
  .card-approval{
    border:1px solid var(--bs-border-color);
    border-left:.45rem solid var(--bs-secondary);
    border-radius:1rem;
    transition:transform .12s ease, box-shadow .12s ease, border-color .12s ease;
  }
  .card-approval:hover{ transform:translateY(-2px); box-shadow:0 .75rem 1.5rem rgba(0,0,0,.06); }
  .card-approval[data-tone="success"]{ border-left-color:var(--bs-success); }
  .card-approval[data-tone="warning"]{ border-left-color:var(--bs-warning); }
  .card-approval[data-tone="danger"]{ border-left-color:var(--bs-danger); }
  .card-approval[data-tone="primary"]{ border-left-color:var(--bs-primary); }
  .card-approval[data-tone="secondary"]{ border-left-color:var(--bs-secondary); }

  .badge-soft{ border:1px solid transparent; }
  .badge-soft-success{ background:rgba(25,135,84,.12); color:#198754; border-color:rgba(25,135,84,.25); }
  .badge-soft-warning{ background:rgba(255,193,7,.18); color:#664d03; border-color:rgba(255,193,7,.35); }
  .badge-soft-danger{  background:rgba(220,53,69,.12); color:#dc3545; border-color:rgba(220,53,69,.25); }
  .badge-soft-primary{ background:rgba(13,110,253,.12); color:#0d6efd; border-color:rgba(13,110,253,.25); }
  .badge-soft-secondary{background:rgba(108,117,125,.12); color:#6c757d; border-color:rgba(108,117,125,.25); }

  .icon-circle{ width:42px; height:42px; display:grid; place-items:center; border-radius:999px; background:var(--bs-light);}
  .line-clamp-2{ display:-webkit-box; -webkit-line-clamp:2; -webkit-box-orient:vertical; overflow:hidden; }
</style>
@endpush

@section('content')
<div class="container my-4">

  <div class="d-flex justify-content-between align-items-center mb-3">
    <div>
      <h1 class="h4 mb-0">My Approvals</h1>
      <small class="text-body-secondary">Review and open approval requests assigned to you.</small>
    </div>
  </div>

  @if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
      <i class="fa fa-check-circle me-1"></i> {{ session('success') }}
      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
  @endif

  @forelse($items as $req)
    @php
      $status = strtolower((string)$req->status);
      $tone = 'secondary'; $badge = 'badge-soft-secondary';
      if(in_array($status,['approved','approve'])) { $tone='success'; $badge='badge-soft-success'; }
      elseif(in_array($status,['pending','waiting','awaiting'])) { $tone='warning'; $badge='badge-soft-warning'; }
      elseif(in_array($status,['rejected','reject'])) { $tone='danger'; $badge='badge-soft-danger'; }
      elseif(in_array($status,['in progress','processing','open'])) { $tone='primary'; $badge='badge-soft-primary'; }
    @endphp

    <div class="card card-approval shadow-sm mb-3" data-tone="{{ $tone }}">
      <div class="card-body d-flex gap-3">
        <div class="icon-circle">
          <i class="fa fa-file-signature"></i>
        </div>

        <div class="flex-grow-1">
          <div class="d-flex justify-content-between flex-wrap gap-2">
            <div class="d-flex align-items-center gap-2">
              <h5 class="mb-0">#{{ $req->id }}</h5>
              <span class="badge {{ $badge }} rounded-pill text-uppercase">{{ $req->status }}</span>
            </div>
            <div class="d-flex align-items-center gap-2">
              <span class="badge text-bg-light">
                <i class="fa fa-list me-1"></i> Lines: {{ $req->lines->count() }}
              </span>
              <span class="badge text-bg-light">
                <i class="fa fa-flag me-1"></i> Step: {{ $req->current_step_no }}
              </span>
              @if($req->updated_at)
                <span class="badge text-bg-light">
                  <i class="fa fa-clock me-1"></i> {{ \Illuminate\Support\Carbon::parse($req->updated_at)->diffForHumans() }}
                </span>
              @endif
              <a href="{{ route('approvals.show', $req->id) }}" class="btn btn-sm btn-primary">
                <i class="fa fa-arrow-right me-1"></i> Open
              </a>
            </div>
          </div>

          <p class="mb-0 mt-2 line-clamp-2 text-body-secondary">
            {{ $req->remarks ?? 'No remarks' }}
          </p>
        </div>
      </div>
    </div>
  @empty
    <div class="text-center py-5">
      <div class="icon-circle mx-auto mb-3" style="width:64px;height:64px;">
        <i class="fa fa-inbox fa-lg text-body-secondary"></i>
      </div>
      <h5 class="mb-1">No pending approvals</h5>
      <p class="text-body-secondary mb-3">You’re all caught up. New requests will appear here.</p>
      @if(Route::has('approvals.create'))
        <a href="{{ route('approvals.create') }}" class="btn btn-outline-primary">
          <i class="fa fa-plus me-1"></i> Create New Request
        </a>
      @endif
    </div>
  @endforelse

  <div class="d-flex justify-content-center mt-4">
    {{ $items->links() }}
  </div>
</div>
@endsection
