<?php
// Start session if not already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include database connection
require_once __DIR__ . '/../config/connection.php';

// Check if user is logged in and has Borrower privileges
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'borrower') {
    header("Location: ../login.php");
    exit();
}

// Get WC information if not already in session
if (!isset($_SESSION['wc_code']) || !isset($_SESSION['wc_description'])) {
    $query_wc = "SELECT wc.wc_code, wc.wc_description, wc.category 
                 FROM borrower_users bu 
                 LEFT JOIN wc_master wc ON bu.wc_id = wc.id 
                 WHERE bu.id = ?";
    $stmt_wc = $conn->prepare($query_wc);
    $stmt_wc->bind_param("i", $_SESSION['user_id']);
    $stmt_wc->execute();
    $result_wc = $stmt_wc->get_result();
    if ($wc_data = $result_wc->fetch_assoc()) {
        $_SESSION['wc_code'] = $wc_data['wc_code'] ?? '-';
        $_SESSION['wc_description'] = $wc_data['wc_description'] ?? '-';
        $_SESSION['wc_category'] = $wc_data['category'] ?? '-';
    }
    $stmt_wc->close();
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? $page_title . ' | Color Access System' : 'Borrower Panel | Color Access System'; ?></title>
    <link rel="icon" href="../images/logo.png" type="image/png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'poppins': ['Poppins', 'sans-serif'],
                    },
                    backgroundImage: {
                        'gradient-primary': 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)',
                        'gradient-side': 'linear-gradient(225deg, #667eea 0%, #764ba2 100%)',
                    },
                    colors: {
                        primary: '#667eea',
                        secondary: '#764ba2',
                        tertiary: '#5a67d8',
                        'light-purple': '#f3e8ff',
                    }
                }
            }
        }
    </script>
    <style>
        /* Additional custom styles */
        .bg-custom-purple {
            background-color: #f3e8ff;
        }
        
        /* Active menu styling */
        .menu-active {
            background-color: rgba(139, 92, 246, 0.3) !important;
            border-left: 4px solid #8b5cf6;
            font-weight: 600;
        }
        
        .submenu-active {
            background-color: rgba(167, 139, 250, 0.25) !important;
            border-left: 3px solid #a78bfa;
            font-weight: 500;
        }

        /* Sidebar transition */
        .sidebar-hidden {
            margin-left: -16rem;
        }

        .sidebar-visible {
            margin-left: 0;
        }

        /* Content transition */
        .content-expanded {
            margin-left: 0;
        }

        .content-normal {
            margin-left: 0;
        }

        @media (min-width: 1024px) {
            .content-normal {
                margin-left: 16rem;
            }
        }

        /* Overlay for mobile */
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 15;
        }

        .sidebar-overlay.active {
            display: block;
        }
    </style>
</head>
<body class="font-poppins bg-custom-purple">
    <!-- Overlay for mobile -->
    <div id="sidebarOverlay" class="sidebar-overlay"></div>

    <div class="flex h-screen overflow-hidden">
        <!-- Sidebar -->
        <div id="sidebar" class="bg-gradient-side text-white w-64 flex flex-col transition-all duration-300 shadow-lg fixed z-20 h-full sidebar-hidden lg:sidebar-visible">
            <div class="flex flex-col items-center py-4 px-6 border-b border-white/10">
                <!-- Logo above Borrower Panel text -->
                <div class="relative flex justify-center">
                    <div class="rounded-full p-1 bg-white ring-4 ring-white/20">
                        <img src="../images/logo.png" alt="Logo" class="h-16 w-16 rounded-full object-cover">
                    </div>
                </div>
                <h2 class="text-xl font-bold mt-3">Borrower Panel</h2>
            </div>

            <div class="flex-1 overflow-y-auto px-4 py-4">
                <!-- Main Menu -->
                <div class="mb-4">
                    <div class="text-xs uppercase font-semibold text-white/70 mb-2 pl-2">Main Menu</div>
                    <ul>
                        <!-- Dashboard Menu (Single) -->
                        <li class="mb-1">
                            <a href="dashboard.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200" data-page="dashboard.php">
                                <i class="fas fa-home w-5"></i>
                                <span class="ml-2">Dashboard</span>
                            </a>
                        </li>
                        
                        <!-- Peminjaman Submenu -->
                        <li class="mb-1">
                            <div class="submenu">
                                <div class="flex items-center justify-between py-2 px-3 rounded-lg hover:bg-white/20 cursor-pointer transition-colors duration-200" onclick="toggleSubmenu(this)">
                                    <div class="flex items-center">
                                        <i class="fas fa-hand-holding w-5"></i>
                                        <span class="ml-2">Peminjaman</span>
                                    </div>
                                    <i class="fas fa-chevron-down text-xs"></i>
                                </div>
                                <ul class="pl-6 mt-1 hidden">
                                    <li class="mb-1">
                                        <a href="ajukan_peminjaman.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200" data-page="ajukan_peminjaman.php">
                                            <i class="fas fa-plus-circle w-5"></i>
                                            <span class="ml-2">Ajukan Peminjaman</span>
                                        </a>
                                    </li>
                                    <li class="mb-1">
                                        <a href="history_peminjaman.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200" data-page="history_peminjaman.php">
                                            <i class="fas fa-history w-5"></i>
                                            <span class="ml-2">History Peminjaman</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Main Content Wrapper -->
        <div id="mainContent" class="flex-1 flex flex-col overflow-hidden transition-all duration-300 content-expanded lg:content-normal">
            <!-- Top Navigation Bar -->
            <header class="bg-white shadow-sm z-10">
                <div class="flex items-center justify-between px-6 py-3">
                    <div class="flex items-center">
                        <button id="toggleSidebar" class="text-gray-600 hover:text-primary focus:outline-none mr-4">
                            <i class="fas fa-bars text-xl"></i>
                        </button>
                        <h1 class="text-xl font-semibold text-gray-800"><?php echo $page_title ?? 'Dashboard'; ?></h1>
                    </div>
                    
                    <!-- User Profile Dropdown -->
                    <div class="relative">
                        <button id="profileDropdown" class="flex items-center px-3 py-2 rounded-full bg-gray-100 hover:bg-gray-200 transition-colors duration-200">
                            <div class="flex items-center">
                                <div class="w-8 h-8 rounded-full bg-primary flex items-center justify-center text-white">
                                    <?php echo isset($_SESSION['nama_borrower']) ? strtoupper(substr($_SESSION['nama_borrower'], 0, 1)) : 'B'; ?>
                                </div>
                                <span class="ml-2 font-medium text-sm text-gray-700 hidden md:block">
                                    <?php echo htmlspecialchars($_SESSION['nama_borrower'] ?? 'Borrower'); ?>
                                </span>
                                <i class="fas fa-chevron-down ml-2 text-xs text-gray-500"></i>
                            </div>
                        </button>
                        
                        <!-- Dropdown Menu -->
                        <div id="profileMenu" class="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-lg py-2 z-20 hidden">
                            <div class="px-4 py-2 text-sm text-gray-500 border-b border-gray-200">
                                <?php echo htmlspecialchars($_SESSION['wc_code'] ?? '-'); ?>
                            </div>
                            <a href="profile.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                <i class="fas fa-user mr-2 text-primary"></i> Profile
                            </a>
                            <div class="border-t border-gray-200 my-1"></div>
                            <a href="../logout.php" class="block px-4 py-2 text-sm text-red-600 hover:bg-gray-100">
                                <i class="fas fa-sign-out-alt mr-2"></i> Logout
                            </a>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Main Content Area -->
            <main class="flex-1 overflow-x-hidden overflow-y-auto bg-custom-purple p-6">