</main>

        <!-- Footer -->
        <footer class="bg-white border-t border-gray-200 mt-auto">
            <div class="container mx-auto px-6 py-4">
                <div class="flex flex-col md:flex-row justify-between items-center">
                    <div class="text-center md:text-left mb-4 md:mb-0">
                        <div class="flex items-center justify-center md:justify-start mb-2">
                            <img src="../images/logo.png" alt="Color Access System Logo" class="h-6 mr-2">
                            <p class="text-gray-600 text-sm">
                                Color Access System &copy; <?php echo date('Y'); ?> - Sistem Peminjaman Warna Furniture
                            </p>
                        </div>
                    </div>
                    <div class="text-sm text-gray-500">
                        Borrower Panel
                    </div>
                </div>
            </div>
        </footer>

        <script>
            // State untuk sidebar
            let sidebarOpen = window.innerWidth >= 1024; // Default open di desktop

            // Elements
            const sidebar = document.getElementById('sidebar');
            const mainContent = document.getElementById('mainContent');
            const toggleButton = document.getElementById('toggleSidebar');
            const overlay = document.getElementById('sidebarOverlay');

            // Toggle sidebar function
            function toggleSidebarFunc() {
                sidebarOpen = !sidebarOpen;
                
                if (window.innerWidth < 1024) {
                    // Mobile behavior
                    if (sidebarOpen) {
                        sidebar.classList.remove('sidebar-hidden');
                        sidebar.classList.add('sidebar-visible');
                        overlay.classList.add('active');
                        document.body.style.overflow = 'hidden';
                    } else {
                        sidebar.classList.add('sidebar-hidden');
                        sidebar.classList.remove('sidebar-visible');
                        overlay.classList.remove('active');
                        document.body.style.overflow = '';
                    }
                } else {
                    // Desktop behavior
                    if (sidebarOpen) {
                        sidebar.classList.remove('sidebar-hidden');
                        sidebar.classList.add('sidebar-visible');
                        mainContent.classList.remove('content-expanded');
                        mainContent.classList.add('content-normal');
                    } else {
                        sidebar.classList.add('sidebar-hidden');
                        sidebar.classList.remove('sidebar-visible');
                        mainContent.classList.add('content-expanded');
                        mainContent.classList.remove('content-normal');
                    }
                }
            }

            // Toggle sidebar on button click
            toggleButton.addEventListener('click', function(e) {
                e.stopPropagation();
                toggleSidebarFunc();
            });

            // Close sidebar when clicking overlay (mobile)
            overlay.addEventListener('click', function() {
                if (window.innerWidth < 1024) {
                    sidebarOpen = true; // Set to true so toggle will close it
                    toggleSidebarFunc();
                }
            });

            // Handle window resize
            window.addEventListener('resize', function() {
                if (window.innerWidth >= 1024) {
                    // Desktop mode
                    overlay.classList.remove('active');
                    document.body.style.overflow = '';
                    if (!sidebarOpen) {
                        mainContent.classList.add('content-expanded');
                        mainContent.classList.remove('content-normal');
                    } else {
                        mainContent.classList.remove('content-expanded');
                        mainContent.classList.add('content-normal');
                    }
                } else {
                    // Mobile mode
                    if (!sidebarOpen) {
                        sidebar.classList.add('sidebar-hidden');
                        sidebar.classList.remove('sidebar-visible');
                    }
                    mainContent.classList.add('content-expanded');
                    mainContent.classList.remove('content-normal');
                }
            });

            // Initialize on page load
            window.addEventListener('DOMContentLoaded', function() {
                if (window.innerWidth < 1024) {
                    sidebar.classList.add('sidebar-hidden');
                    sidebar.classList.remove('sidebar-visible');
                    mainContent.classList.add('content-expanded');
                    sidebarOpen = false;
                } else {
                    sidebar.classList.remove('sidebar-hidden');
                    sidebar.classList.add('sidebar-visible');
                    mainContent.classList.add('content-normal');
                    sidebarOpen = true;
                }
            });
            
            // Toggle profile dropdown
            document.getElementById('profileDropdown').addEventListener('click', function(e) {
                e.stopPropagation();
                document.getElementById('profileMenu').classList.toggle('hidden');
            });
            
            // Close dropdown when clicking outside
            document.addEventListener('click', function(event) {
                const profileDropdown = document.getElementById('profileDropdown');
                const profileMenu = document.getElementById('profileMenu');
                
                if (!profileDropdown.contains(event.target) && !profileMenu.contains(event.target)) {
                    profileMenu.classList.add('hidden');
                }
            });
            
            // Track the currently open submenu
            let openSubmenu = null;
            
            // Toggle submenu with auto-close functionality
            function toggleSubmenu(element) {
                const submenu = element.nextElementSibling;
                const icon = element.querySelector('.fa-chevron-down, .fa-chevron-up');
                
                // If there's already an open submenu and it's not the one being clicked
                if (openSubmenu && openSubmenu !== submenu) {
                    // Close the currently open submenu
                    openSubmenu.classList.add('hidden');
                    
                    // Find the icon in the parent element of the open submenu and reset it
                    const openSubmenuIcon = openSubmenu.previousElementSibling.querySelector('.fa-chevron-down, .fa-chevron-up');
                    if (openSubmenuIcon) {
                        openSubmenuIcon.classList.remove('fa-chevron-up');
                        openSubmenuIcon.classList.add('fa-chevron-down');
                    }
                }
                
                // Toggle the clicked submenu
                submenu.classList.toggle('hidden');
                icon.classList.toggle('fa-chevron-down');
                icon.classList.toggle('fa-chevron-up');
                
                // Update the currently open submenu reference
                if (submenu.classList.contains('hidden')) {
                    openSubmenu = null;
                } else {
                    openSubmenu = submenu;
                }
            }
            
            // Function to set active menu based on current page
            function setActiveMenu() {
                // Get current page filename
                const currentPage = window.location.pathname.split('/').pop();
                
                // Find all menu links
                const menuLinks = document.querySelectorAll('a[data-page]');
                
                menuLinks.forEach(function(link) {
                    const linkPage = link.getAttribute('data-page');
                    
                    // Check if this is the current page
                    if (linkPage === currentPage) {
                        // Check if it's a submenu item
                        const parentSubmenu = link.closest('.submenu > ul');
                        
                        if (parentSubmenu) {
                            // It's a submenu item - add submenu-active class
                            link.classList.add('submenu-active');
                            
                            // Open the parent submenu
                            const parentToggle = parentSubmenu.previousElementSibling;
                            if (parentSubmenu.classList.contains('hidden')) {
                                toggleSubmenu(parentToggle);
                            }
                            
                            // Also highlight the parent submenu header
                            parentToggle.classList.add('menu-active');
                        } else {
                            // It's a main menu item - add menu-active class
                            link.classList.add('menu-active');
                        }
                    }
                });
            }
            
            // Initialize - ensure all submenus are closed on page load
            document.addEventListener('DOMContentLoaded', function() {
                const submenus = document.querySelectorAll('.submenu > ul');
                submenus.forEach(function(submenu) {
                    submenu.classList.add('hidden');
                });
                
                // Set active menu after DOM is loaded
                setActiveMenu();
            });
        </script>
    </div>
</body>
</html>