<?php
// Start session
session_start();

// Include database connection for audit log
require_once 'config/connection.php';

// Log audit before destroying session
if (isset($_SESSION['user_id']) && isset($_SESSION['user_type'])) {
    $audit_query = "INSERT INTO audit_logs (action_type, user_id, user_type, details, timestamp, ip_address) 
                    VALUES ('LOGOUT', ?, ?, ?, NOW(), ?)";
    $audit_stmt = $conn->prepare($audit_query);
    $user_id = $_SESSION['user_id'];
    $user_type = $_SESSION['user_type'];
    $username = $_SESSION['username'] ?? 'Unknown';
    $audit_details = "User {$username} logged out";
    $ip_address = $_SERVER['REMOTE_ADDR'];
    $audit_stmt->bind_param("isss", $user_id, $user_type, $audit_details, $ip_address);
    $audit_stmt->execute();
    $audit_stmt->close();
}

// Destroy session
session_unset();
session_destroy();

// Close connection
$conn->close();

// Redirect to login page
header("Location: login.php");
exit();
?>