<?php
// Set page title
$page_title = "Stock Color Panel Management";

// Include header
include '../template_it/header.php';

// Get buyer filter from URL
$buyer_filter = isset($_GET['buyer_id']) ? (int)$_GET['buyer_id'] : 0;

// Query untuk mengambil data buyers untuk filter dropdown
$query_buyers = "SELECT id, nama_buyer, kode_buyer FROM buyers ORDER BY nama_buyer ASC";
$result_buyers = $conn->query($query_buyers);
?>

<style>
.split-container {
    display: flex;
    gap: 0;
    height: calc(100vh - 200px);
}

.left-panel {
    flex: 0 0 50%;
    overflow-y: auto;
    padding-right: 1rem;
    border-right: 2px solid #e5e7eb;
}

.right-panel {
    flex: 0 0 50%;
    overflow-y: auto;
    padding-left: 1rem;
    display: none;
}

.right-panel.active {
    display: block;
    animation: slideIn 0.3s ease-out;
}

@keyframes slideIn {
    from {
        opacity: 0;
        transform: translateX(20px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

.master-card.selected {
    border: 2px solid #3b82f6;
    box-shadow: 0 4px 6px -1px rgba(59, 130, 246, 0.3);
}

.left-panel::-webkit-scrollbar,
.right-panel::-webkit-scrollbar {
    width: 8px;
}

.left-panel::-webkit-scrollbar-track,
.right-panel::-webkit-scrollbar-track {
    background: #f1f1f1;
}

.left-panel::-webkit-scrollbar-thumb,
.right-panel::-webkit-scrollbar-thumb {
    background: #888;
    border-radius: 4px;
}

.left-panel::-webkit-scrollbar-thumb:hover,
.right-panel::-webkit-scrollbar-thumb:hover {
    background: #555;
}
</style>

<!-- Stock Color Panel Content -->
<div class="container mx-auto">
    <!-- Page Header -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-box text-blue-600 mr-2"></i>
                    Stock Color Panel Management
                </h2>
                <p class="text-gray-600 mt-1">Kelola Master Color, Panel, dan Stock Items</p>
            </div>
            <div>
                <a href="form_data.php" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg transition-colors duration-200">
                    <i class="fas fa-plus mr-2"></i>
                    Tambah Data Baru
                </a>
            </div>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="flex items-center gap-4">
            <label class="text-gray-700 font-semibold">Filter by Buyer:</label>
            <select id="buyerFilter" class="px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" onchange="filterByBuyer()">
                <option value="0">-- Semua Buyer --</option>
                <?php while($buyer = $result_buyers->fetch_assoc()): ?>
                    <option value="<?php echo $buyer['id']; ?>" <?php echo ($buyer_filter == $buyer['id']) ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($buyer['nama_buyer']) . ' (' . htmlspecialchars($buyer['kode_buyer']) . ')'; ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </div>
    </div>

    <!-- Split Screen Container -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="split-container">
            <!-- LEFT PANEL: Master Color & Panel -->
            <div class="left-panel" id="leftPanel">
                <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center sticky top-0 bg-white py-2 z-10 border-b border-gray-200">
                    <i class="fas fa-palette text-purple-600 mr-2"></i>
                    Master Color & Panel
                </h3>
                
                <?php
                // Query untuk mengambil master color dengan panel dan stock count
                $query_master = "
                    SELECT 
                        mc.id as master_color_id,
                        mc.code_color as master_code,
                        mc.color_name,
                        mc.lemari,
                        mc.lemari_number,
                        mc.description,
                        b.nama_buyer,
                        b.kode_buyer,
                        c.nama_collection,
                        COUNT(DISTINCT mcp.id) as total_panels,
                        COUNT(DISTINCT csi.id) as total_stock_items,
                        SUM(csi.qty) as total_qty
                    FROM master_color mc
                    LEFT JOIN buyers b ON mc.buyer_id = b.id
                    LEFT JOIN collections c ON mc.collection_id = c.id
                    LEFT JOIN master_color_panel mcp ON mc.id = mcp.master_color_id
                    LEFT JOIN color_stock_items csi ON mc.id = csi.master_color_id
                ";
                
                if ($buyer_filter > 0) {
                    $query_master .= " WHERE mc.buyer_id = $buyer_filter";
                }
                
                $query_master .= " GROUP BY mc.id ORDER BY mc.created_at DESC";
                
                $result_master = $conn->query($query_master);
                
                if ($result_master->num_rows > 0):
                ?>
                    <div class="space-y-4">
                        <?php while($master = $result_master->fetch_assoc()): ?>
                            <div class="master-card border border-gray-200 rounded-lg overflow-hidden hover:shadow-lg transition-shadow" id="master-<?php echo $master['master_color_id']; ?>">
                                <!-- Master Color Header -->
                                <div class="bg-gradient-to-r from-purple-50 to-blue-50 p-4 border-b border-gray-200">
                                    <div class="flex items-center justify-between">
                                        <div class="flex items-center gap-4">
                                            <div class="bg-purple-600 text-white px-4 py-2 rounded-lg font-bold">
                                                <?php echo htmlspecialchars($master['master_code']); ?>
                                            </div>
                                            <div>
                                                <h4 class="text-lg font-bold text-gray-800">
                                                    <?php echo htmlspecialchars($master['color_name']); ?>
                                                </h4>
                                                <p class="text-sm text-gray-600">
                                                    <span class="font-semibold"><?php echo htmlspecialchars($master['nama_buyer']); ?></span>
                                                    (<?php echo htmlspecialchars($master['kode_buyer']); ?>) - 
                                                    <?php echo htmlspecialchars($master['nama_collection']); ?>
                                                </p>
                                            </div>
                                        </div>
                                        <div class="flex items-center gap-2">
                                            <span class="bg-purple-100 text-purple-800 px-3 py-1 rounded-full text-sm font-semibold">
                                                <i class="fas fa-th-large mr-1"></i>
                                                <?php echo $master['total_panels']; ?> Panel
                                            </span>
                                            <span class="bg-green-100 text-green-800 px-3 py-1 rounded-full text-sm font-semibold">
                                                <i class="fas fa-boxes mr-1"></i>
                                                <?php echo $master['total_stock_items']; ?> Stock
                                            </span>
                                            <button 
                                                onclick="showStockItems(<?php echo $master['master_color_id']; ?>, '<?php echo htmlspecialchars($master['master_code']); ?>', '<?php echo htmlspecialchars(addslashes($master['color_name'])); ?>')"
                                                class="bg-blue-500 hover:bg-blue-600 text-white px-3 py-2 rounded-lg transition-colors"
                                                title="Lihat Stock Items">
                                                <i class="fas fa-arrow-right"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="mt-2 flex items-center gap-4 text-xs text-gray-500">
                                        <span>
                                            <i class="fas fa-warehouse mr-1"></i>
                                            Lemari <?php echo htmlspecialchars($master['lemari']); ?> - No. <?php echo htmlspecialchars($master['lemari_number']); ?>
                                        </span>
                                        <?php if($master['total_qty'] > 0): ?>
                                            <span class="text-green-600 font-semibold">
                                                <i class="fas fa-cubes mr-1"></i>
                                                Total Qty: <?php echo $master['total_qty']; ?>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    <?php if(!empty($master['description'])): ?>
                                        <div class="mt-2">
                                            <p class="text-sm text-gray-600">
                                                <i class="fas fa-info-circle mr-1"></i>
                                                <?php echo htmlspecialchars($master['description']); ?>
                                            </p>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <!-- Master Color Panels -->
                                <?php
                                $master_color_id = $master['master_color_id'];
                                $query_panels = "
                                    SELECT 
                                        mcp.id as panel_id,
                                        mcp.panel_code,
                                        mcp.color_name,
                                        mcp.lemari as panel_lemari,
                                        mcp.rack_number as panel_rack_number,
                                        mcp.position_number as panel_position_number,
                                        mcp.is_master_only
                                    FROM master_color_panel mcp
                                    WHERE mcp.master_color_id = $master_color_id
                                    ORDER BY mcp.created_at DESC
                                ";
                                $result_panels = $conn->query($query_panels);
                                
                                if ($result_panels->num_rows > 0):
                                ?>
                                    <div class="p-4 bg-gray-50">
                                        <div class="space-y-2">
                                            <?php while($panel = $result_panels->fetch_assoc()): ?>
                                                <div class="bg-white border border-gray-200 rounded-lg p-3">
                                                    <div class="flex items-center justify-between">
                                                        <div class="flex items-center gap-3">
                                                            <span class="bg-blue-500 text-white px-3 py-1 rounded font-mono text-sm font-bold">
                                                                <?php echo htmlspecialchars($panel['panel_code']); ?>
                                                            </span>
                                                            <span class="font-semibold text-gray-700">
                                                                <?php echo htmlspecialchars($panel['color_name']); ?>
                                                            </span>
                                                            <?php if($panel['is_master_only'] == 1): ?>
                                                                <span class="bg-red-100 text-red-800 px-2 py-1 rounded text-xs font-semibold">
                                                                    <i class="fas fa-lock mr-1"></i>Master Only
                                                                </span>
                                                            <?php endif; ?>
                                                        </div>
                                                        <span class="text-xs text-gray-500">
                                                            Lemari <?php echo htmlspecialchars($panel['panel_lemari']); ?> - 
                                                            Rack <?php echo htmlspecialchars($panel['panel_rack_number']); ?> - 
                                                            Pos <?php echo htmlspecialchars($panel['panel_position_number']); ?>
                                                        </span>
                                                    </div>
                                                </div>
                                            <?php endwhile; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endwhile; ?>
                    </div>
                <?php else: ?>
                    <div class="text-center py-12">
                        <i class="fas fa-boxes text-gray-300 text-6xl mb-4"></i>
                        <p class="text-gray-500 text-lg">Tidak ada data Master Color</p>
                        <?php if($buyer_filter > 0): ?>
                            <p class="text-gray-400 text-sm mt-2">Coba ubah filter buyer</p>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>

            <!-- RIGHT PANEL: Stock Items -->
            <div class="right-panel" id="rightPanel">
                <div class="sticky top-0 bg-white py-2 z-10 border-b border-gray-200 mb-4">
                    <div class="flex items-center justify-between">
                        <h3 class="text-xl font-bold text-gray-800 flex items-center">
                            <i class="fas fa-boxes text-green-600 mr-2"></i>
                            Stock Items
                        </h3>
                        <button 
                            onclick="closeStockPanel()"
                            class="bg-red-500 hover:bg-red-600 text-white px-3 py-2 rounded-lg transition-colors">
                            <i class="fas fa-times mr-1"></i> Tutup
                        </button>
                    </div>
                    <div id="stockHeader" class="mt-2 text-sm text-gray-600">
                        <!-- Dynamic header akan muncul disini -->
                    </div>
                </div>
                
                <div id="stockItemsContainer">
                    <!-- Stock items akan dimuat disini via AJAX -->
                    <div class="text-center py-12">
                        <i class="fas fa-hand-pointer text-gray-300 text-6xl mb-4"></i>
                        <p class="text-gray-500">Pilih Master Color untuk melihat Stock Items</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function filterByBuyer() {
    const buyerId = document.getElementById('buyerFilter').value;
    if (buyerId == 0) {
        window.location.href = 'stock_color_panel.php';
    } else {
        window.location.href = 'stock_color_panel.php?buyer_id=' + buyerId;
    }
}

function showStockItems(masterColorId, masterCode, colorName) {
    // Hilangkan highlight dari semua card
    document.querySelectorAll('.master-card').forEach(card => {
        card.classList.remove('selected');
    });
    
    // Highlight card yang dipilih
    document.getElementById('master-' + masterColorId).classList.add('selected');
    
    // Show right panel
    const rightPanel = document.getElementById('rightPanel');
    rightPanel.classList.add('active');
    
    // Update header
    document.getElementById('stockHeader').innerHTML = `
        <div class="flex items-center gap-2">
            <span class="bg-purple-600 text-white px-3 py-1 rounded font-bold">${masterCode}</span>
            <span class="font-semibold">${colorName}</span>
        </div>
    `;
    
    // Load stock items via AJAX
    loadStockItems(masterColorId);
}

function closeStockPanel() {
    document.getElementById('rightPanel').classList.remove('active');
    document.querySelectorAll('.master-card').forEach(card => {
        card.classList.remove('selected');
    });
}

function loadStockItems(masterColorId) {
    const container = document.getElementById('stockItemsContainer');
    container.innerHTML = '<div class="text-center py-8"><i class="fas fa-spinner fa-spin text-4xl text-blue-500"></i><p class="mt-2 text-gray-500">Memuat data...</p></div>';
    
    // AJAX request untuk load stock items
    fetch('get_stock_items.php?master_color_id=' + masterColorId)
        .then(response => response.text())
        .then(html => {
            container.innerHTML = html;
        })
        .catch(error => {
            console.error('Error:', error);
            container.innerHTML = '<div class="text-center py-8 text-red-500"><i class="fas fa-exclamation-triangle text-4xl"></i><p class="mt-2">Error memuat data</p></div>';
        });
}
</script>

<?php
// Include footer
include '../template_it/footer.php';
?>