<?php
// Set page title
$page_title = "Reset Data Warna";

// Include header
include '../template_it/header.php';

// Check if user has permission (only IT)
if ($_SESSION['user_type'] != 'it') {
    header("Location: ../dashboard.php");
    exit();
}
?>

<!-- Reset Data Content -->
<div class="container mx-auto max-w-4xl">
    <!-- Alert Messages -->
    <div id="alertSuccess" class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4 hidden" role="alert">
        <strong class="font-bold">Berhasil!</strong>
        <span class="block sm:inline" id="successMessage"></span>
    </div>
    
    <div id="alertError" class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4 hidden" role="alert">
        <strong class="font-bold">Error!</strong>
        <span class="block sm:inline" id="errorMessage"></span>
    </div>

    <!-- Warning Header -->
    <div class="bg-red-50 border-l-4 border-red-500 p-6 mb-6 rounded-lg shadow-md">
        <div class="flex items-center mb-3">
            <i class="fas fa-exclamation-triangle text-red-500 text-3xl mr-3"></i>
            <h2 class="text-2xl font-bold text-red-800">PERINGATAN: Reset Data Warna</h2>
        </div>
        <p class="text-red-700 text-sm mb-3">
            Halaman ini digunakan untuk menghapus data warna secara permanen. 
            <strong>Tindakan ini tidak dapat dibatalkan!</strong>
        </p>
        <div class="bg-white border border-red-300 rounded p-3 mt-3">
            <p class="text-sm font-semibold text-gray-800 mb-2">Data yang AKAN DIHAPUS:</p>
            <ul class="text-sm text-gray-700 list-disc list-inside space-y-1">
                <li>Master Color</li>
                <li>Master Color Panel</li>
                <li>Color Stock Items</li>
            </ul>
            <p class="text-sm font-semibold text-green-800 mt-3 mb-2">Data yang TIDAK DIHAPUS (Tetap Aman):</p>
            <ul class="text-sm text-green-700 list-disc list-inside space-y-1">
                <li>Buyers</li>
                <li>Users (Borrower, Admin, IT, Approval)</li>
                <li>Components</li>
                <li>Collections</li>
                <li>WC Master</li>
            </ul>
        </div>
    </div>

    <!-- Reset Options -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <h3 class="text-xl font-bold text-gray-800 mb-4">
            <i class="fas fa-trash-alt text-red-600 mr-2"></i>Pilih Data yang Akan Dihapus
        </h3>

        <!-- Option 1: Reset by Buyer -->
        <div class="border-2 border-gray-300 rounded-lg p-5 mb-4 hover:border-red-400 transition-all">
            <h4 class="font-bold text-lg text-gray-800 mb-3">
                <i class="fas fa-building text-blue-600 mr-2"></i>Hapus Data Warna Berdasarkan Buyer
            </h4>
            <p class="text-gray-600 text-sm mb-4">
                Menghapus semua <strong>Master Color, Panel, dan Stock Items</strong> untuk buyer tertentu.
                <span class="text-green-700 font-semibold">Data buyer itu sendiri TIDAK akan dihapus.</span>
            </p>
            
            <form id="formResetByBuyer" onsubmit="resetByBuyer(event)">
                <div class="mb-3">
                    <label class="block text-gray-700 font-semibold mb-2">
                        Pilih Buyer <span class="text-red-500">*</span>
                    </label>
                    <select 
                        id="buyer_id_reset" 
                        name="buyer_id"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-red-500"
                        required>
                        <option value="">-- Pilih Buyer --</option>
                        <?php
                        $query_buyers = "SELECT id, nama_buyer, kode_buyer FROM buyers ORDER BY nama_buyer ASC";
                        $result_buyers = $conn->query($query_buyers);
                        while($buyer = $result_buyers->fetch_assoc()):
                        ?>
                            <option value="<?php echo $buyer['id']; ?>">
                                <?php echo htmlspecialchars($buyer['nama_buyer']); ?> (<?php echo $buyer['kode_buyer']; ?>)
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                
                <button 
                    type="submit" 
                    class="bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-6 rounded-lg transition-colors">
                    <i class="fas fa-trash mr-2"></i>Hapus Data Warna Buyer
                </button>
            </form>
        </div>

        <!-- Option 2: Reset by Master Color -->
        <div class="border-2 border-gray-300 rounded-lg p-5 mb-4 hover:border-red-400 transition-all">
            <h4 class="font-bold text-lg text-gray-800 mb-3">
                <i class="fas fa-palette text-purple-600 mr-2"></i>Hapus Master Color Tertentu
            </h4>
            <p class="text-gray-600 text-sm mb-4">
                Menghapus satu <strong>Master Color</strong> beserta <strong>Panel dan Stock Items</strong>-nya.
            </p>
            
            <form id="formResetByColor" onsubmit="resetByMasterColor(event)">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-3">
                    <div>
                        <label class="block text-gray-700 font-semibold mb-2">
                            Pilih Buyer <span class="text-red-500">*</span>
                        </label>
                        <select 
                            id="buyer_id_color" 
                            class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-red-500"
                            required
                            onchange="loadMasterColors(this.value)">
                            <option value="">-- Pilih Buyer --</option>
                            <?php
                            $result_buyers->data_seek(0);
                            while($buyer = $result_buyers->fetch_assoc()):
                            ?>
                                <option value="<?php echo $buyer['id']; ?>">
                                    <?php echo htmlspecialchars($buyer['nama_buyer']); ?> (<?php echo $buyer['kode_buyer']; ?>)
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    
                    <div>
                        <label class="block text-gray-700 font-semibold mb-2">
                            Pilih Master Color <span class="text-red-500">*</span>
                        </label>
                        <select 
                            id="master_color_id" 
                            name="master_color_id"
                            class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-red-500"
                            required
                            disabled>
                            <option value="">-- Pilih Buyer Dulu --</option>
                        </select>
                    </div>
                </div>
                
                <button 
                    type="submit" 
                    class="bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-6 rounded-lg transition-colors">
                    <i class="fas fa-trash mr-2"></i>Hapus Master Color
                </button>
            </form>
        </div>

        <!-- Option 3: Reset ALL Color Data -->
        <div class="border-2 border-red-500 rounded-lg p-5 bg-red-50">
            <h4 class="font-bold text-lg text-red-800 mb-3">
                <i class="fas fa-exclamation-circle text-red-600 mr-2"></i>Hapus SEMUA Data Warna
            </h4>
            <p class="text-red-700 text-sm mb-2">
                <strong>SANGAT BERBAHAYA!</strong> Menghapus <strong>SEMUA Master Color, Panel, dan Stock Items</strong> dari database.
            </p>
            <p class="text-green-700 text-sm font-semibold mb-4">
                <i class="fas fa-shield-alt mr-1"></i>
                Data Buyers, Users, Components, Collections, dan WC Master tetap aman (tidak dihapus).
            </p>
            
            <button 
                onclick="resetAllData()" 
                class="bg-red-700 hover:bg-red-800 text-white font-bold py-2 px-6 rounded-lg transition-colors">
                <i class="fas fa-bomb mr-2"></i>HAPUS SEMUA DATA WARNA
            </button>
        </div>
    </div>

    <!-- Statistics -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h3 class="text-xl font-bold text-gray-800 mb-4">
            <i class="fas fa-chart-bar text-green-600 mr-2"></i>Statistik Database
        </h3>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
            <?php
            // Get statistics for data yang AKAN DIHAPUS
            $query_stats = "
                SELECT 
                    (SELECT COUNT(*) FROM master_color) as total_master_colors,
                    (SELECT COUNT(*) FROM master_color_panel) as total_panels,
                    (SELECT COUNT(*) FROM color_stock_items) as total_stock_items
            ";
            $result_stats = $conn->query($query_stats);
            $stats = $result_stats->fetch_assoc();
            ?>
            
            <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 text-center">
                <i class="fas fa-palette text-blue-600 text-3xl mb-2"></i>
                <p class="text-gray-600 text-sm">Master Colors</p>
                <p class="text-3xl font-bold text-blue-600"><?php echo number_format($stats['total_master_colors']); ?></p>
            </div>
            
            <div class="bg-purple-50 border border-purple-200 rounded-lg p-4 text-center">
                <i class="fas fa-layer-group text-purple-600 text-3xl mb-2"></i>
                <p class="text-gray-600 text-sm">Panels</p>
                <p class="text-3xl font-bold text-purple-600"><?php echo number_format($stats['total_panels']); ?></p>
            </div>
            
            <div class="bg-green-50 border border-green-200 rounded-lg p-4 text-center">
                <i class="fas fa-boxes text-green-600 text-3xl mb-2"></i>
                <p class="text-gray-600 text-sm">Stock Items</p>
                <p class="text-3xl font-bold text-green-600"><?php echo number_format($stats['total_stock_items']); ?></p>
            </div>
        </div>

        <!-- Safe Data Statistics - VERSI 2 -->
        <div class="border-t pt-4">
            <h4 class="font-semibold text-gray-800 mb-3">
                <i class="fas fa-shield-alt text-green-600 mr-2"></i>Data yang Aman (Tidak Akan Dihapus)
            </h4>
            <div class="grid grid-cols-2 md:grid-cols-4 gap-3">
                <?php
                // Get statistics for safe data
                $query_safe = "
                    SELECT 
                        (SELECT COUNT(*) FROM buyers) as total_buyers,
                        (SELECT COUNT(*) FROM color_components) as total_components,
                        (SELECT COUNT(*) FROM collections) as total_collections,
                        (SELECT COUNT(*) FROM wc_master) as total_wc_master
                ";
                $result_safe = $conn->query($query_safe);
                $safe_stats = $result_safe->fetch_assoc();
                ?>
                
                <div class="bg-gray-50 border border-gray-200 rounded p-3 text-center">
                    <p class="text-xs text-gray-600">Buyers</p>
                    <p class="text-xl font-bold text-gray-700"><?php echo $safe_stats['total_buyers']; ?></p>
                </div>
                
                <div class="bg-gray-50 border border-gray-200 rounded p-3 text-center">
                    <p class="text-xs text-gray-600">Components</p>
                    <p class="text-xl font-bold text-gray-700"><?php echo $safe_stats['total_components']; ?></p>
                </div>
                
                <div class="bg-gray-50 border border-gray-200 rounded p-3 text-center">
                    <p class="text-xs text-gray-600">Collections</p>
                    <p class="text-xl font-bold text-gray-700"><?php echo $safe_stats['total_collections']; ?></p>
                </div>
                
                <div class="bg-gray-50 border border-gray-200 rounded p-3 text-center">
                    <p class="text-xs text-gray-600">WC Master</p>
                    <p class="text-xl font-bold text-gray-700"><?php echo $safe_stats['total_wc_master']; ?></p>
                </div>
            </div>
            
            <p class="text-xs text-gray-500 mt-3 text-center">
                <i class="fas fa-info-circle mr-1"></i>
                Data Users (IT, Admin, Borrower, Approval) juga tetap aman dan tidak akan dihapus
            </p>
        </div>
    </div>
</div>

<script>
// Load master colors based on buyer
function loadMasterColors(buyerId) {
    const colorSelect = document.getElementById('master_color_id');
    
    if (!buyerId) {
        colorSelect.innerHTML = '<option value="">-- Pilih Buyer Dulu --</option>';
        colorSelect.disabled = true;
        return;
    }
    
    colorSelect.innerHTML = '<option value="">Loading...</option>';
    colorSelect.disabled = true;
    
    fetch('get_master_colors_by_buyer.php?buyer_id=' + buyerId)
        .then(response => response.json())
        .then(data => {
            if (data.success && data.colors && data.colors.length > 0) {
                let options = '<option value="">-- Pilih Master Color --</option>';
                data.colors.forEach(color => {
                    options += `<option value="${color.id}">${color.code_color} - ${color.color_name}</option>`;
                });
                colorSelect.innerHTML = options;
                colorSelect.disabled = false;
            } else {
                colorSelect.innerHTML = '<option value="">-- Tidak Ada Data --</option>';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            colorSelect.innerHTML = '<option value="">-- Error Loading Data --</option>';
        });
}

// Reset by Buyer
function resetByBuyer(event) {
    event.preventDefault();
    
    const buyerId = document.getElementById('buyer_id_reset').value;
    const buyerText = document.getElementById('buyer_id_reset').selectedOptions[0].text;
    
    if (!buyerId) {
        showError('Silakan pilih buyer!');
        return;
    }
    
    const confirmMsg = `PERINGATAN!\n\nAnda akan menghapus data warna untuk buyer: ${buyerText}\n\nYang akan dihapus:\n✓ Master Colors\n✓ Panels\n✓ Stock Items\n\nYang TIDAK dihapus (tetap aman):\n✓ Data Buyer itu sendiri\n✓ Collections buyer\n\nTindakan ini TIDAK DAPAT DIBATALKAN!\n\nKetik "HAPUS" untuk konfirmasi:`;
    
    const confirmation = prompt(confirmMsg);
    
    if (confirmation !== 'HAPUS') {
        showError('Penghapusan dibatalkan. Anda harus mengetik "HAPUS" untuk konfirmasi.');
        return;
    }
    
    // Show loading
    showError('Memproses penghapusan...');
    
    fetch('process_reset_color.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `action=reset_by_buyer&buyer_id=${buyerId}`
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showSuccess(data.message);
            setTimeout(() => {
                location.reload();
            }, 2000);
        } else {
            showError(data.message || 'Terjadi kesalahan');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showError('Error: ' + error);
    });
}

// Reset by Master Color
function resetByMasterColor(event) {
    event.preventDefault();
    
    const masterColorId = document.getElementById('master_color_id').value;
    const colorText = document.getElementById('master_color_id').selectedOptions[0].text;
    
    if (!masterColorId) {
        showError('Silakan pilih master color!');
        return;
    }
    
    const confirmMsg = `PERINGATAN!\n\nAnda akan menghapus master color: ${colorText}\n\nYang akan dihapus:\n✓ Master Color\n✓ Panel\n✓ Semua Stock Items\n\nTindakan ini TIDAK DAPAT DIBATALKAN!\n\nKetik "HAPUS" untuk konfirmasi:`;
    
    const confirmation = prompt(confirmMsg);
    
    if (confirmation !== 'HAPUS') {
        showError('Penghapusan dibatalkan. Anda harus mengetik "HAPUS" untuk konfirmasi.');
        return;
    }
    
    // Show loading
    showError('Memproses penghapusan...');
    
    fetch('process_reset_color.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `action=reset_by_master_color&master_color_id=${masterColorId}`
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showSuccess(data.message);
            setTimeout(() => {
                location.reload();
            }, 2000);
        } else {
            showError(data.message || 'Terjadi kesalahan');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showError('Error: ' + error);
    });
}

// Reset ALL Color Data
function resetAllData() {
    const confirmMsg1 = `PERINGATAN EKSTREM!\n\nAnda akan menghapus SEMUA DATA WARNA!\n\nYang akan dihapus:\n✓ SEMUA Master Colors\n✓ SEMUA Panels\n✓ SEMUA Stock Items\n\nYang TETAP AMAN (tidak dihapus):\n✓ Buyers\n✓ Users\n✓ Components\n✓ Collections\n✓ WC Master\n\nTindakan ini TIDAK DAPAT DIBATALKAN!\n\nKetik "HAPUS SEMUA" untuk konfirmasi:`;
    
    const confirmation1 = prompt(confirmMsg1);
    
    if (confirmation1 !== 'HAPUS SEMUA') {
        showError('Penghapusan dibatalkan.');
        return;
    }
    
    const confirmMsg2 = `Konfirmasi TERAKHIR!\n\nApakah Anda BENAR-BENAR YAKIN ingin menghapus SEMUA data warna?\n\nKetik "YA SAYA YAKIN" untuk melanjutkan:`;
    
    const confirmation2 = prompt(confirmMsg2);
    
    if (confirmation2 !== 'YA SAYA YAKIN') {
        showError('Penghapusan dibatalkan.');
        return;
    }
    
    // Show loading
    showError('Memproses penghapusan SEMUA data warna...');
    
    fetch('process_reset_color.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'action=reset_all_data'
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showSuccess(data.message);
            setTimeout(() => {
                location.reload();
            }, 2000);
        } else {
            showError(data.message || 'Terjadi kesalahan');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showError('Error: ' + error);
    });
}

// Show success message
function showSuccess(message) {
    const alertSuccess = document.getElementById('alertSuccess');
    const successMessage = document.getElementById('successMessage');
    
    successMessage.textContent = message;
    alertSuccess.classList.remove('hidden');
    
    document.getElementById('alertError').classList.add('hidden');
    
    // Scroll to top
    window.scrollTo({ top: 0, behavior: 'smooth' });
}

// Show error message
function showError(message) {
    const alertError = document.getElementById('alertError');
    const errorMessage = document.getElementById('errorMessage');
    
    errorMessage.textContent = message;
    alertError.classList.remove('hidden');
    
    document.getElementById('alertSuccess').classList.add('hidden');
    
    // Scroll to top
    window.scrollTo({ top: 0, behavior: 'smooth' });
}
</script>

<?php
include '../template_it/footer.php';
?>