<?php
session_start();
require_once '../config/connection.php';

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'it') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

header('Content-Type: application/json');

$action = isset($_POST['action']) ? $_POST['action'] : '';

$conn->begin_transaction();

try {
    switch($action) {
        case 'add_wc':
            $wc_code = isset($_POST['wc_code']) ? $conn->real_escape_string(trim($_POST['wc_code'])) : '';
            $wc_description = isset($_POST['wc_description']) ? $conn->real_escape_string(trim($_POST['wc_description'])) : '';
            $category = isset($_POST['category']) ? $conn->real_escape_string(trim($_POST['category'])) : '';
            
            if (empty($wc_code) || empty($wc_description) || empty($category)) {
                throw new Exception('Semua field wajib diisi');
            }
            
            // Validate category
            if (!in_array($category, ['PAINTING', 'PACKING'])) {
                throw new Exception('Category tidak valid');
            }
            
            // Check if WC code already exists
            $check_query = "SELECT id FROM wc_master WHERE wc_code = '$wc_code'";
            $check_result = $conn->query($check_query);
            
            if($check_result->num_rows > 0) {
                throw new Exception('WC Code sudah digunakan');
            }
            
            $query = "INSERT INTO wc_master (wc_code, wc_description, category, is_active, created_at) 
                     VALUES ('$wc_code', '$wc_description', '$category', 1, NOW())";
            
            if(!$conn->query($query)) {
                throw new Exception($conn->error);
            }
            
            $conn->commit();
            
            // Log audit
            $audit_query = "INSERT INTO audit_logs (action_type, user_id, user_type, details, timestamp, ip_address) 
                           VALUES ('ADD_WC', ?, 'it', ?, NOW(), ?)";
            $audit_stmt = $conn->prepare($audit_query);
            $user_id = $_SESSION['user_id'];
            $audit_details = "Added Work Center: $wc_code - $wc_description ($category)";
            $ip_address = $_SERVER['REMOTE_ADDR'];
            $audit_stmt->bind_param("iss", $user_id, $audit_details, $ip_address);
            $audit_stmt->execute();
            $audit_stmt->close();
            
            echo json_encode(['success' => true, 'message' => 'Work Center berhasil ditambahkan']);
            break;
            
        case 'edit_wc':
            $wc_id = isset($_POST['wc_id']) ? (int)$_POST['wc_id'] : 0;
            $wc_code = isset($_POST['wc_code']) ? $conn->real_escape_string(trim($_POST['wc_code'])) : '';
            $wc_description = isset($_POST['wc_description']) ? $conn->real_escape_string(trim($_POST['wc_description'])) : '';
            $category = isset($_POST['category']) ? $conn->real_escape_string(trim($_POST['category'])) : '';
            $is_active = isset($_POST['is_active']) ? (int)$_POST['is_active'] : 1;
            
            if ($wc_id <= 0) {
                throw new Exception('WC ID tidak valid');
            }
            
            if (empty($wc_code) || empty($wc_description) || empty($category)) {
                throw new Exception('Semua field wajib diisi');
            }
            
            // Validate category
            if (!in_array($category, ['PAINTING', 'PACKING'])) {
                throw new Exception('Category tidak valid');
            }
            
            // Validate is_active
            if (!in_array($is_active, [0, 1])) {
                throw new Exception('Status tidak valid');
            }
            
            // Check if WC exists
            $check_wc = "SELECT id FROM wc_master WHERE id = $wc_id";
            $result_wc = $conn->query($check_wc);
            
            if ($result_wc->num_rows == 0) {
                throw new Exception('Work Center tidak ditemukan');
            }
            
            // Check if WC code already exists (except current WC)
            $check_code = "SELECT id FROM wc_master WHERE wc_code = '$wc_code' AND id != $wc_id";
            $result_code = $conn->query($check_code);
            
            if ($result_code->num_rows > 0) {
                throw new Exception('WC Code sudah digunakan oleh Work Center lain');
            }
            
            // If deactivating WC, check if it's being used by borrower
            if ($is_active == 0) {
                $check_usage = "SELECT COUNT(*) as total FROM borrower_users WHERE wc_id = $wc_id";
                $result_usage = $conn->query($check_usage);
                $usage_data = $result_usage->fetch_assoc();
                
                if($usage_data['total'] > 0) {
                    throw new Exception('Work Center tidak dapat dinonaktifkan karena masih digunakan oleh borrower');
                }
            }
            
            $query = "UPDATE wc_master SET 
                     wc_code = '$wc_code',
                     wc_description = '$wc_description',
                     category = '$category',
                     is_active = $is_active
                     WHERE id = $wc_id";
            
            if(!$conn->query($query)) {
                throw new Exception($conn->error);
            }
            
            $conn->commit();
            
            // Log audit
            $audit_query = "INSERT INTO audit_logs (action_type, user_id, user_type, details, timestamp, ip_address) 
                           VALUES ('EDIT_WC', ?, 'it', ?, NOW(), ?)";
            $audit_stmt = $conn->prepare($audit_query);
            $user_id = $_SESSION['user_id'];
            $status_text = $is_active ? 'Active' : 'Inactive';
            $audit_details = "Updated Work Center ID: $wc_id - $wc_code - $wc_description ($category) - Status: $status_text";
            $ip_address = $_SERVER['REMOTE_ADDR'];
            $audit_stmt->bind_param("iss", $user_id, $audit_details, $ip_address);
            $audit_stmt->execute();
            $audit_stmt->close();
            
            echo json_encode(['success' => true, 'message' => 'Work Center berhasil diupdate']);
            break;
            
        case 'delete_wc':
            $wc_id = isset($_POST['wc_id']) ? (int)$_POST['wc_id'] : 0;
            
            if ($wc_id <= 0) {
                throw new Exception('WC ID tidak valid');
            }
            
            // Check if WC exists and get data for audit
            $check_wc = "SELECT wc_code, wc_description, category FROM wc_master WHERE id = $wc_id";
            $result_wc = $conn->query($check_wc);
            
            if ($result_wc->num_rows == 0) {
                throw new Exception('Work Center tidak ditemukan');
            }
            
            $wc_data = $result_wc->fetch_assoc();
            
            // Check if WC is being used by borrower
            $check_usage = "SELECT COUNT(*) as total FROM borrower_users WHERE wc_id = $wc_id";
            $result_usage = $conn->query($check_usage);
            $usage_data = $result_usage->fetch_assoc();
            
            if($usage_data['total'] > 0) {
                throw new Exception('Work Center tidak dapat dihapus karena masih digunakan oleh borrower');
            }
            
            $query = "DELETE FROM wc_master WHERE id = $wc_id";
            
            if(!$conn->query($query)) {
                throw new Exception($conn->error);
            }
            
            $conn->commit();
            
            // Log audit
            $audit_query = "INSERT INTO audit_logs (action_type, user_id, user_type, details, timestamp, ip_address) 
                           VALUES ('DELETE_WC', ?, 'it', ?, NOW(), ?)";
            $audit_stmt = $conn->prepare($audit_query);
            $user_id = $_SESSION['user_id'];
            $wc_code = $wc_data['wc_code'];
            $wc_description = $wc_data['wc_description'];
            $category = $wc_data['category'];
            $audit_details = "Deleted Work Center: $wc_code - $wc_description ($category)";
            $ip_address = $_SERVER['REMOTE_ADDR'];
            $audit_stmt->bind_param("iss", $user_id, $audit_details, $ip_address);
            $audit_stmt->execute();
            $audit_stmt->close();
            
            echo json_encode(['success' => true, 'message' => 'Work Center berhasil dihapus']);
            break;
            
        default:
            throw new Exception('Invalid action');
            break;
    }
    
} catch(Exception $e) {
    $conn->rollback();
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
?>