<?php
session_start();
require_once '../config/connection.php';

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'it') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

header('Content-Type: application/json');

$wc_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($wc_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid WC ID']);
    exit();
}

try {
    $query = "SELECT id, wc_code, wc_description, category, is_active, created_at 
              FROM wc_master 
              WHERE id = $wc_id";
    
    $result = $conn->query($query);
    
    if ($result && $result->num_rows > 0) {
        $wc = $result->fetch_assoc();
        echo json_encode([
            'success' => true,
            'wc' => $wc
        ]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Work Center not found']);
    }
    
} catch(Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
?>