<?php
include '../config/connection.php';

$master_color_id = isset($_GET['master_color_id']) ? (int)$_GET['master_color_id'] : 0;

if ($master_color_id > 0) {
    // Query untuk mengambil stock items berdasarkan master_color_id
    $query_stocks = "
        SELECT 
            csi.id,
            csi.code_color,
            csi.qty,
            csi.lokasi_penyimpanan,
            csi.code_barang_lemari5,
            csi.manufacturing_date,
            csi.expired_date,
            csi.status,
            mc.code_color as master_code,
            mc.color_name as master_color_name,
            cc.component_name,
            col.nama_collection,
            b.nama_buyer
        FROM color_stock_items csi
        LEFT JOIN master_color mc ON csi.master_color_id = mc.id
        LEFT JOIN color_components cc ON csi.component_id = cc.id
        LEFT JOIN collections col ON mc.collection_id = col.id
        LEFT JOIN buyers b ON mc.buyer_id = b.id
        WHERE csi.master_color_id = $master_color_id
        ORDER BY csi.code_barang_lemari5 ASC, csi.created_at DESC
    ";
    
    $result_stocks = $conn->query($query_stocks);
    
    if ($result_stocks && $result_stocks->num_rows > 0):
    ?>
        <div class="mb-4 p-4 bg-blue-50 border border-blue-200 rounded-lg">
            <p class="text-sm text-blue-800">
                <i class="fas fa-info-circle mr-2"></i>
                Total Stock Items: <strong><?php echo $result_stocks->num_rows; ?></strong> items
            </p>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Code Color</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Component</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Code Barang<br>Lemari 5</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Buyer</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Collection</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Qty</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Lokasi</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php while($stock = $result_stocks->fetch_assoc()): ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-3 whitespace-nowrap">
                                <span class="bg-indigo-100 text-indigo-800 px-3 py-1 rounded-lg font-mono font-semibold text-sm">
                                    <?php echo htmlspecialchars($stock['code_color']); ?>
                                </span>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap">
                                <span class="bg-yellow-100 text-yellow-800 px-2 py-1 rounded text-xs font-medium">
                                    <?php echo htmlspecialchars($stock['component_name']); ?>
                                </span>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap text-center">
                                <span class="bg-orange-100 text-orange-800 px-3 py-1 rounded-lg font-mono font-bold text-sm">
                                    <?php echo htmlspecialchars($stock['code_barang_lemari5']); ?>
                                </span>
                            </td>
                            <td class="px-4 py-3">
                                <span class="text-sm text-gray-700 font-medium">
                                    <?php echo htmlspecialchars($stock['nama_buyer']); ?>
                                </span>
                            </td>
                            <td class="px-4 py-3">
                                <span class="text-sm text-gray-700">
                                    <?php echo htmlspecialchars($stock['nama_collection']); ?>
                                </span>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap text-center">
                                <span class="font-bold text-gray-800 text-lg">
                                    <?php echo $stock['qty']; ?>
                                </span>
                            </td>
                            <td class="px-4 py-3">
                                <span class="text-sm text-gray-700">
                                    <i class="fas fa-map-marker-alt text-red-500 mr-1"></i>
                                    <?php echo htmlspecialchars($stock['lokasi_penyimpanan']); ?>
                                </span>
                            </td>
                            <td class="px-4 py-3">
                                <div class="text-xs text-gray-600">
                                    <div class="mb-1">
                                        <i class="fas fa-industry text-blue-500 mr-1"></i>
                                        <strong>Produksi:</strong><br>
                                        <?php echo date('d/m/Y', strtotime($stock['manufacturing_date'])); ?>
                                    </div>
                                    <div>
                                        <i class="fas fa-calendar-times text-red-500 mr-1"></i>
                                        <strong>Kadaluarsa:</strong><br>
                                        <?php echo date('d/m/Y', strtotime($stock['expired_date'])); ?>
                                    </div>
                                </div>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap">
                                <?php
                                $status_classes = [
                                    'available' => 'bg-green-100 text-green-800',
                                    'borrowed' => 'bg-orange-100 text-orange-800',
                                    'expired' => 'bg-red-100 text-red-800'
                                ];
                                $status_icons = [
                                    'available' => 'fa-check-circle',
                                    'borrowed' => 'fa-hand-holding',
                                    'expired' => 'fa-times-circle'
                                ];
                                $status_text = [
                                    'available' => 'Tersedia',
                                    'borrowed' => 'Dipinjam',
                                    'expired' => 'Kadaluarsa'
                                ];
                                $status = $stock['status'];
                                ?>
                                <span class="<?php echo $status_classes[$status]; ?> px-3 py-1 rounded-full text-xs font-semibold">
                                    <i class="fas <?php echo $status_icons[$status]; ?> mr-1"></i>
                                    <?php echo $status_text[$status]; ?>
                                </span>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="text-center py-12">
            <i class="fas fa-inbox text-gray-300 text-6xl mb-4"></i>
            <p class="text-gray-500 text-lg">Tidak ada Stock Items untuk Master Color ini</p>
            <p class="text-gray-400 text-sm mt-2">Stock items akan muncul setelah data diinput dengan mode "With Components Stock"</p>
        </div>
    <?php endif;
} else {
    echo '<div class="text-center py-12 text-red-500">
            <i class="fas fa-exclamation-triangle text-6xl mb-4"></i>
            <p>Invalid Master Color ID</p>
          </div>';
}
?>