<!-- get_stock_item_detail.php -->
<?php
session_start();
require_once '../config/connection.php';

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'it') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

header('Content-Type: application/json');

$stock_id = isset($_GET['stock_id']) ? (int)$_GET['stock_id'] : 0;

if ($stock_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid stock ID']);
    exit();
}

try {
    $query = "SELECT 
                csi.id,
                csi.code_color,
                csi.code_barang_lemari5,
                csi.qty,
                csi.lokasi_penyimpanan,
                csi.manufacturing_date,
                csi.expired_date,
                csi.status,
                csi.component_id,
                mc.code_color as master_code,
                mc.color_name,
                cc.component_name
              FROM color_stock_items csi
              LEFT JOIN master_color mc ON csi.master_color_id = mc.id
              LEFT JOIN color_components cc ON csi.component_id = cc.id
              WHERE csi.id = ?";
    
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $stock_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $data = $result->fetch_assoc();
        echo json_encode([
            'success' => true,
            'data' => $data
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Stock item tidak ditemukan'
        ]);
    }
    
    $stmt->close();
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}

$conn->close();
?>