<?php
session_start();
require_once '../config/connection.php';

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'it') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

header('Content-Type: application/json');

// Get the highest code_barang_lemari5 from database
$query = "SELECT CAST(code_barang_lemari5 AS UNSIGNED) as num 
          FROM color_stock_items 
          WHERE code_barang_lemari5 REGEXP '^[0-9]+$' 
          ORDER BY CAST(code_barang_lemari5 AS UNSIGNED) DESC 
          LIMIT 1";

$result = $conn->query($query);

$next_code = 1; // Default start from 1

if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $next_code = intval($row['num']) + 1;
}

// Validate not exceeding 999
if ($next_code > 999) {
    echo json_encode([
        'success' => false,
        'message' => 'Code Barang Lemari 5 telah mencapai batas maksimum (999)',
        'next_code' => 999
    ]);
} else {
    echo json_encode([
        'success' => true,
        'next_code' => $next_code,
        'formatted_code' => str_pad($next_code, 3, '0', STR_PAD_LEFT)
    ]);
}

$conn->close();
?><?php
session_start();
require_once '../config/connection.php';

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'it') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

header('Content-Type: application/json');

// Get the highest code_barang_lemari5 from database
$query = "SELECT CAST(code_barang_lemari5 AS UNSIGNED) as num 
          FROM color_stock_items 
          WHERE code_barang_lemari5 REGEXP '^[0-9]+$' 
          ORDER BY CAST(code_barang_lemari5 AS UNSIGNED) DESC 
          LIMIT 1";

$result = $conn->query($query);

$next_code = 1; // Default start from 1

if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $next_code = intval($row['num']) + 1;
}

// Validate not exceeding 999
if ($next_code > 999) {
    echo json_encode([
        'success' => false,
        'message' => 'Code Barang Lemari 5 telah mencapai batas maksimum (999)',
        'next_code' => 999
    ]);
} else {
    echo json_encode([
        'success' => true,
        'next_code' => $next_code,
        'formatted_code' => str_pad($next_code, 3, '0', STR_PAD_LEFT)
    ]);
}

$conn->close();
?>