<?php
require_once '../config/connection.php';

header('Content-Type: application/json');

$master_code = isset($_GET['master_code']) ? $conn->real_escape_string($_GET['master_code']) : '';

if (empty($master_code)) {
    echo json_encode(['success' => false, 'message' => 'Master code is required']);
    exit;
}

try {
    $query = "
        SELECT 
            mc.code_color as master_code,
            mc.color_name,
            mc.qr_code,
            b.nama_buyer
        FROM master_color mc
        LEFT JOIN buyers b ON mc.buyer_id = b.id
        WHERE mc.code_color = '$master_code'
        LIMIT 1
    ";
    
    $result = $conn->query($query);
    
    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        
        if (!empty($row['qr_code'])) {
            echo json_encode([
                'success' => true,
                'master_code' => $row['master_code'],
                'color_name' => $row['color_name'],
                'buyer_name' => $row['nama_buyer'],
                'qr_image' => $row['qr_code']
            ]);
        } else {
            echo json_encode(['success' => false, 'message' => 'QR Code belum di-generate']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Master color not found']);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}

$conn->close();
?>