<?php
session_start();
require_once '../config/connection.php';

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'it') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

header('Content-Type: application/json');

$borrower_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($borrower_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid borrower ID']);
    exit();
}

try {
    $query = "SELECT 
                bu.id, 
                bu.username, 
                bu.nama_borrower, 
                bu.nik, 
                bu.email, 
                bu.wc_id,
                bu.status, 
                bu.created_at,
                wc.wc_code,
                wc.wc_description,
                wc.category as wc_category
              FROM borrower_users bu
              LEFT JOIN wc_master wc ON bu.wc_id = wc.id
              WHERE bu.id = $borrower_id";
    
    $result = $conn->query($query);
    
    if ($result && $result->num_rows > 0) {
        $borrower = $result->fetch_assoc();
        echo json_encode([
            'success' => true,
            'borrower' => $borrower
        ]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Borrower not found']);
    }
    
} catch(Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
?>