<?php
// generate_qr_stock.php
require_once '../config/connection.php';
require_once '../vendor/autoload.php'; // Composer autoload untuk phpqrcode

use chillerlan\QRCode\QRCode;
use chillerlan\QRCode\QROptions;

header('Content-Type: application/json');

$master_color_id = isset($_GET['master_color_id']) ? (int)$_GET['master_color_id'] : 0;

if ($master_color_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid Master Color ID']);
    exit;
}

try {
    // Query untuk mengambil stock items berdasarkan master color
    $query = "
        SELECT 
            csi.id,
            csi.code_color,
            csi.qr_code,
            cc.component_name,
            mc.code_color as master_code,
            mc.color_name as master_name
        FROM color_stock_items csi
        LEFT JOIN color_components cc ON csi.component_id = cc.id
        LEFT JOIN master_color mc ON csi.master_color_id = mc.id
        WHERE csi.master_color_id = $master_color_id
        ORDER BY csi.code_color ASC
    ";
    
    $result = $conn->query($query);
    
    if (!$result || $result->num_rows == 0) {
        echo json_encode(['success' => false, 'message' => 'Tidak ada stock items untuk Master Color ini']);
        exit;
    }
    
    $qr_codes = [];
    
    // Set QR Code options
    $options = new QROptions([
        'version'    => 5,
        'outputType' => QRCode::OUTPUT_IMAGE_PNG,
        'eccLevel'   => QRCode::ECC_L,
        'scale'      => 10,
        'imageBase64' => true,
    ]);
    
    $qrcode = new QRCode($options);
    
    while ($row = $result->fetch_assoc()) {
        $code_color = $row['code_color'];
        $qr_image = null;
        
        // Cek apakah QR code sudah ada di database
        if (!empty($row['qr_code'])) {
            $qr_image = $row['qr_code'];
        } else {
            // Generate QR code baru
            $qr_image = $qrcode->render($code_color);
            
            // Simpan QR code ke database
            $qr_escaped = $conn->real_escape_string($qr_image);
            $update_query = "UPDATE color_stock_items SET qr_code = '$qr_escaped' WHERE id = {$row['id']}";
            $conn->query($update_query);
        }
        
        $qr_codes[] = [
            'id' => $row['id'],
            'code_color' => $code_color,
            'component_name' => $row['component_name'],
            'master_code' => $row['master_code'],
            'master_name' => $row['master_name'],
            'qr_image' => $qr_image
        ];
    }
    
    echo json_encode([
        'success' => true,
        'qr_codes' => $qr_codes,
        'total' => count($qr_codes)
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}

$conn->close();
?>