<?php
require_once '../config/connection.php';
require_once '../vendor/autoload.php';

use chillerlan\QRCode\QRCode;
use chillerlan\QRCode\QROptions;

header('Content-Type: application/json');

$master_color_id = isset($_GET['master_color_id']) ? (int)$_GET['master_color_id'] : 0;

if ($master_color_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid Master Color ID']);
    exit;
}

try {
    $query = "
        SELECT 
            mc.id,
            mc.code_color as master_code,
            mc.color_name,
            mc.qr_code,
            b.nama_buyer,
            b.kode_buyer,
            c.nama_collection
        FROM master_color mc
        LEFT JOIN buyers b ON mc.buyer_id = b.id
        LEFT JOIN collections c ON mc.collection_id = c.id
        WHERE mc.id = $master_color_id
        LIMIT 1
    ";
    
    $result = $conn->query($query);
    
    if (!$result || $result->num_rows == 0) {
        echo json_encode(['success' => false, 'message' => 'Master Color tidak ditemukan']);
        exit;
    }
    
    $row = $result->fetch_assoc();
    $master_code = $row['master_code'];
    
    $options = new QROptions([
        'version'    => 5,
        'outputType' => QRCode::OUTPUT_IMAGE_PNG,
        'eccLevel'   => QRCode::ECC_L,
        'scale'      => 10,
        'imageBase64' => true,
    ]);
    
    $qrcode = new QRCode($options);
    $qr_image = $qrcode->render($master_code);
    
    $qr_escaped = $conn->real_escape_string($qr_image);
    $update_query = "UPDATE master_color SET qr_code = '$qr_escaped' WHERE id = $master_color_id";
    $conn->query($update_query);
    
    echo json_encode([
        'success' => true,
        'master_code' => $master_code,
        'color_name' => $row['color_name'],
        'buyer_name' => $row['nama_buyer'],
        'qr_image' => $qr_image
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}

$conn->close();
?>