<!-- form_data.php -->
<?php
// Set page title
$page_title = "Input Data Warna Baru";

// Include header
include '../template_it/header.php';

// Query untuk mengambil data buyers
$query_buyers = "SELECT * FROM buyers ORDER BY nama_buyer ASC";
$result_buyers = $conn->query($query_buyers);

// Query untuk mengambil data components
$query_components = "SELECT * FROM color_components ORDER BY component_name ASC";
$result_components = $conn->query($query_components);

// Query untuk mengambil data finish components (hanya component Finish saja - ID 5)
$query_finish_components = "SELECT * FROM color_components WHERE id = 5 ORDER BY component_name ASC";
$result_finish_components = $conn->query($query_finish_components);
?>

<!-- Form Data Content -->
<div class="container mx-auto max-w-6xl">
    <!-- Alert Messages -->
    <div id="alertSuccess" class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4 hidden" role="alert">
        <strong class="font-bold">Berhasil!</strong>
        <span class="block sm:inline" id="successMessage"></span>
    </div>
    
    <div id="alertError" class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4 hidden" role="alert">
        <strong class="font-bold">Error!</strong>
        <span class="block sm:inline" id="errorMessage"></span>
    </div>

    <!-- Check for success/error from URL -->
    <?php if (isset($_GET['success']) && isset($_SESSION['success_message'])): ?>
    <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
        <strong class="font-bold">Berhasil!</strong>
        <span class="block sm:inline"><?php echo htmlspecialchars($_SESSION['success_message']); ?></span>
    </div>
    <?php unset($_SESSION['success_message']); ?>
    <?php endif; ?>

    <?php if (isset($_GET['error']) && isset($_SESSION['error_message'])): ?>
    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
        <strong class="font-bold">Error!</strong>
        <span class="block sm:inline"><?php echo htmlspecialchars($_SESSION['error_message']); ?></span>
    </div>
    <?php unset($_SESSION['error_message']); ?>
    <?php endif; ?>

    <!-- MODE SELECTION -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="flex items-center mb-4 border-b pb-3">
            <div class="bg-purple-500 rounded-full p-2 mr-3">
                <i class="fas fa-layer-group text-white"></i>
            </div>
            <h2 class="text-xl font-bold text-gray-800">Pilih Mode Input Data</h2>
        </div>

        <p class="text-gray-600 mb-4">Silakan pilih mode input data sesuai kebutuhan Anda:</p>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <!-- Option 1: Only Master -->
            <div class="mode-option border-2 border-gray-300 rounded-lg p-6 cursor-pointer hover:border-blue-500 hover:bg-blue-50 transition-all"
                 onclick="selectMode('only_master')" id="mode_only_master">
                <div class="flex items-center mb-3">
                    <div class="bg-blue-100 rounded-full p-3 mr-3">
                        <i class="fas fa-palette text-blue-600 text-2xl"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold text-gray-800">Only Master</h3>
                        <p class="text-sm text-gray-600">Hanya Master Color & Panel</p>
                    </div>
                </div>
                <p class="text-sm text-gray-600 mb-3">
                    Input hanya data Master Color dan Master Panel saja tanpa stock items. 
                    Cocok untuk data referensi atau panel yang belum ada stock.
                </p>
                <div class="flex items-center text-sm text-gray-700">
                    <i class="fas fa-check-circle text-green-500 mr-2"></i>
                    <span>Bagian 1: Master Color & Panel</span>
                </div>
                <div class="flex items-center text-sm text-gray-400 mt-1">
                    <i class="fas fa-times-circle text-gray-400 mr-2"></i>
                    <span>Bagian 2: Stock Items (Dilewati)</span>
                </div>
            </div>

            <!-- Option 2: With Components Stock -->
            <div class="mode-option border-2 border-gray-300 rounded-lg p-6 cursor-pointer hover:border-green-500 hover:bg-green-50 transition-all"
                 onclick="selectMode('with_stock')" id="mode_with_stock">
                <div class="flex items-center mb-3">
                    <div class="bg-green-100 rounded-full p-3 mr-3">
                        <i class="fas fa-boxes text-green-600 text-2xl"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold text-gray-800">With Components Stock</h3>
                        <p class="text-sm text-gray-600">Master + Stock Items Lengkap</p>
                    </div>
                </div>
                <p class="text-sm text-gray-600 mb-3">
                    Input lengkap termasuk Master Color, Panel, dan Stock Items per component. 
                    Untuk data warna yang siap dipinjam.
                </p>
                <div class="flex items-center text-sm text-gray-700">
                    <i class="fas fa-check-circle text-green-500 mr-2"></i>
                    <span>Bagian 1: Master Color & Panel</span>
                </div>
                <div class="flex items-center text-sm text-gray-700 mt-1">
                    <i class="fas fa-check-circle text-green-500 mr-2"></i>
                    <span>Bagian 2: Stock Items (Wajib)</span>
                </div>
            </div>
        </div>

        <!-- Selected Mode Indicator -->
        <div id="selectedModeIndicator" class="mt-4 p-4 bg-blue-50 border border-blue-200 rounded-lg hidden">
            <p class="text-sm font-semibold text-blue-800">
                <i class="fas fa-info-circle mr-2"></i>
                Mode terpilih: <span id="selectedModeText"></span>
            </p>
        </div>
    </div>

    <!-- Form Container (Hidden until mode selected) -->
    <form id="formDataWarna" method="POST" action="process_form_data.php" enctype="multipart/form-data" style="display: none;">
        
        <!-- Hidden Input for Mode -->
        <input type="hidden" name="input_mode" id="input_mode" value="">

        <!-- SECTION 1: Master Color & Panel Information -->
        <div class="bg-white rounded-lg shadow-md p-6 mb-6">
            <div class="flex items-center mb-4 border-b pb-3">
                <div class="bg-blue-500 rounded-full p-2 mr-3">
                    <i class="fas fa-palette text-white"></i>
                </div>
                <h2 class="text-xl font-bold text-gray-800">BAGIAN 1: Informasi Master Color & Panel</h2>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <!-- Buyer -->
                <div>
                    <label for="buyer_id" class="block text-sm font-medium text-gray-700 mb-2">
                        Buyer <span class="text-red-500">*</span>
                    </label>
                    <select id="buyer_id" name="buyer_id" 
                            class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                            required onchange="loadCollections(); generateCodeColor();">
                        <option value="">-- Pilih Buyer --</option>
                        <?php while($buyer = $result_buyers->fetch_assoc()): ?>
                            <option value="<?php echo $buyer['id']; ?>" data-kode="<?php echo $buyer['kode_buyer']; ?>">
                                <?php echo htmlspecialchars($buyer['nama_buyer']); ?> (<?php echo $buyer['kode_buyer']; ?>)
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>

                <!-- Collection -->
                <div>
                    <label for="collection_id" class="block text-sm font-medium text-gray-700 mb-2">
                        Collection <span class="text-red-500">*</span>
                    </label>
                    <select id="collection_id" name="collection_id" 
                            class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                            required disabled>
                        <option value="">-- Pilih Buyer Terlebih Dahulu --</option>
                    </select>
                </div>

                <!-- Code Color (Auto Generate) -->
                <div>
                    <label for="code_color" class="block text-sm font-medium text-gray-700 mb-2">
                        Code Color <span class="text-red-500">*</span>
                    </label>
                    <input type="text" id="code_color" name="code_color" 
                           class="w-full px-4 py-2 border border-gray-300 rounded-lg bg-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                           placeholder="Auto Generate" readonly required>
                    <p class="text-xs text-gray-500 mt-1">Format: 00001, 00002, 00003 (Auto Generate)</p>
                </div>

                <!-- Color Name -->
                <div>
                    <label for="color_name" class="block text-sm font-medium text-gray-700 mb-2">
                        Nama Warna <span class="text-red-500">*</span>
                    </label>
                    <input type="text" id="color_name" name="color_name" 
                           class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                           placeholder="Contoh: WDG 001" required>
                </div>

                <!-- Lemari -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Lemari <span class="text-red-500">*</span>
                    </label>
                    <div class="flex items-center space-x-4">
                        <label class="flex items-center cursor-pointer">
                            <input type="radio" name="lemari" value="A" class="mr-2" required>
                            <span>Lemari A</span>
                        </label>
                        <label class="flex items-center cursor-pointer">
                            <input type="radio" name="lemari" value="B" class="mr-2">
                            <span>Lemari B</span>
                        </label>
                        <label class="flex items-center cursor-pointer">
                            <input type="radio" name="lemari" value="C" class="mr-2">
                            <span>Lemari C</span>
                        </label>
                        <label class="flex items-center cursor-pointer">
                            <input type="radio" name="lemari" value="D" class="mr-2">
                            <span>Lemari D</span>
                        </label>
                    </div>
                </div>

                <!-- Lemari Number -->
                <div>
                    <label for="lemari_number" class="block text-sm font-medium text-gray-700 mb-2">
                        Nomor Lemari <span class="text-red-500">*</span>
                    </label>
                    <input type="number" id="lemari_number" name="lemari_number" 
                           class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                           placeholder="Contoh: 1" min="1" required>
                </div>

                <!-- Rack Number -->
                <div>
                    <label for="rack_number" class="block text-sm font-medium text-gray-700 mb-2">
                        Nomor Rack <span class="text-red-500">*</span>
                    </label>
                    <input type="text" id="rack_number" name="rack_number" 
                           class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                           placeholder="Contoh: 0001" maxlength="4" required>
                    <p class="text-xs text-gray-500 mt-1">Format 4 digit: 0001, 0002, dst</p>
                </div>

                <!-- Position Number -->
                <div>
                    <label for="position_number" class="block text-sm font-medium text-gray-700 mb-2">
                        Nomor Posisi <span class="text-red-500">*</span>
                    </label>
                    <input type="text" id="position_number" name="position_number" 
                           class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                           placeholder="Contoh: 01" maxlength="2" required>
                    <p class="text-xs text-gray-500 mt-1">Format 2 digit: 01-99</p>
                </div>

                <!-- Panel Master Only Checkbox -->
                <div class="md:col-span-2">
                    <label class="flex items-center space-x-3 p-4 bg-red-50 border border-red-200 rounded-lg cursor-pointer hover:bg-red-100 transition-colors">
                        <input type="checkbox" id="is_master_only" name="is_master_only" value="1" 
                               class="w-5 h-5 text-red-600 border-gray-300 rounded focus:ring-red-500">
                        <div>
                            <span class="font-semibold text-gray-800">
                                <i class="fas fa-lock text-red-500 mr-2"></i>Panel Master Only (Tidak boleh dipinjam)
                            </span>
                            <p class="text-sm text-gray-600 mt-1">Centang jika panel ini hanya untuk referensi di lemari dan tidak dapat dipinjam oleh borrower.</p>
                        </div>
                    </label>
                </div>

                <!-- Description / Notes -->
                <div class="md:col-span-2">
                    <label for="description" class="block text-sm font-medium text-gray-700 mb-2">
                        Keterangan / Catatan
                    </label>
                    <textarea id="description" name="description" rows="3"
                              class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                              placeholder="Catatan tambahan untuk warna ini (opsional)"></textarea>
                </div>
            </div>
        </div>

        <!-- SECTION 2: Color Stock Items (Conditional - Only for "with_stock" mode) -->
        <div id="section2Container" class="bg-white rounded-lg shadow-md p-6 mb-6" style="display: none;">
            <div class="flex items-center justify-between mb-4 border-b pb-3">
                <div class="flex items-center">
                    <div class="bg-purple-500 rounded-full p-2 mr-3">
                        <i class="fas fa-boxes text-white"></i>
                    </div>
                    <h2 class="text-xl font-bold text-gray-800">BAGIAN 2: Stock Items Color (Per Component)</h2>
                </div>
            </div>

            <!-- Component Type Selection -->
            <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4 mb-6">
                <h3 class="font-semibold text-gray-800 mb-3">
                    <i class="fas fa-layer-group text-yellow-600 mr-2"></i>Pilih Tipe Component
                </h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <label class="flex items-center space-x-3 p-3 bg-white border-2 border-gray-300 rounded-lg cursor-pointer hover:border-yellow-500 transition-all">
                        <input type="radio" name="component_type" value="finish_only" class="w-4 h-4 text-yellow-600" onchange="updateComponentType()">
                        <div>
                            <span class="font-semibold text-gray-800">Hanya Finish (Selesai)</span>
                            <p class="text-xs text-gray-600">Hanya component Finish yang akan tersedia</p>
                        </div>
                    </label>
                    <label class="flex items-center space-x-3 p-3 bg-white border-2 border-gray-300 rounded-lg cursor-pointer hover:border-yellow-500 transition-all">
                        <input type="radio" name="component_type" value="with_steps" class="w-4 h-4 text-yellow-600" onchange="updateComponentType()">
                        <div>
                            <span class="font-semibold text-gray-800">Beserta Step</span>
                            <p class="text-xs text-gray-600">Semua component tersedia (lengkap)</p>
                        </div>
                    </label>
                </div>
            </div>

            <!-- Code Barang Counter Info -->
            <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mb-6">
                <div class="flex items-center justify-between">
                    <div>
                        <h3 class="font-semibold text-gray-800 mb-1">
                            <i class="fas fa-info-circle text-blue-600 mr-2"></i>Informasi Code Barang Lemari 5
                        </h3>
                        <p class="text-sm text-gray-600">
                            Code barang akan di-generate otomatis berurutan dimulai dari: <strong id="startingCodeBarang">001</strong>
                        </p>
                    </div>
                    <button type="button" onclick="loadNextCodeBarang()" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-lg text-sm">
                        <i class="fas fa-sync-alt mr-2"></i>Refresh
                    </button>
                </div>
                <p class="text-xs text-gray-500 mt-2">
                    <i class="fas fa-lightbulb mr-1"></i>
                    Contoh: Jika Qty Component 1 = 3, maka akan generate code 001, 002, 003. Component berikutnya akan mulai dari 004.
                </p>
            </div>

            <div class="flex justify-end mb-4">
                <button type="button" onclick="addStockItem()" 
                        class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-lg transition-colors duration-200">
                    <i class="fas fa-plus mr-2"></i>Tambah Component
                </button>
            </div>

            <!-- Stock Items Container -->
            <div id="stockItemsContainer">
                <!-- Stock Item #1 (Default) -->
                <div class="stock-item border border-gray-200 rounded-lg p-4 mb-4 bg-gray-50" data-item="1">
                    <div class="flex items-center justify-between mb-3">
                        <h3 class="font-semibold text-gray-800">
                            <i class="fas fa-box text-purple-500 mr-2"></i>Item #<span class="item-number">1</span>
                        </h3>
                        <button type="button" onclick="removeStockItem(1)" 
                                class="text-red-500 hover:text-red-700 transition-colors duration-200 remove-btn" style="display:none;">
                            <i class="fas fa-trash-alt"></i> Hapus
                        </button>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                        <!-- Component -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Component <span class="text-red-500">*</span>
                            </label>
                            <select name="stock_items[1][component_id]" 
                                    class="stock-component w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                    data-item="1">
                                <option value="">-- Pilih Component --</option>
                            </select>
                        </div>

                        <!-- Quantity -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Quantity <span class="text-red-500">*</span>
                            </label>
                            <input type="number" name="stock_items[1][qty]" 
                                class="stock-qty w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                placeholder="0" min="1" onchange="updateCodeBarangPreview()">
                            <p class="text-xs text-gray-500 mt-1">Akan generate <span class="qty-info">0</span> code barang</p>
                        </div>

                        <!-- Code Barang Range (Editable) -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Code Barang Lemari 5 <span class="text-red-500">*</span>
                            </label>
                            <div class="flex gap-2 items-center">
                                <input type="text" name="stock_items[1][code_barang_start]" 
                                    class="code-barang-start w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 font-mono text-sm"
                                    placeholder="001" maxlength="3" 
                                    onkeypress="return event.charCode >= 48 && event.charCode <= 57"
                                    onblur="validateAndUpdateCodeBarang(this, 1)"
                                    oninput="this.value = this.value.replace(/[^0-9]/g, '')">
                                <span class="text-gray-500 qty-separator" style="display:none;">-</span>
                                <input type="text" name="stock_items[1][code_barang_end]" 
                                    class="code-barang-end w-full px-3 py-2 border border-gray-300 rounded-lg bg-gray-100 font-mono text-sm"
                                    placeholder="001" readonly style="display:none;">
                            </div>
                            <div class="code-barang-validation mt-1 text-xs"></div>
                        </div>

                        <!-- Nomor Lemari -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Nomor Lemari <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="stock_items[1][lemari_number]" 
                                class="stock-lemari-number w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                placeholder="5, 6, 7, dst" maxlength="10">
                            <p class="text-xs text-gray-500 mt-1">Nomor lemari untuk stock item ini</p>
                        </div>

                        <!-- Lokasi Penyimpanan -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Lokasi Penyimpanan <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="stock_items[1][lokasi_penyimpanan]" 
                                class="stock-lokasi w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                placeholder="Contoh: Color Room, Rack A 001">
                        </div>

                        <!-- Manufacturing Date -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Tanggal Produksi <span class="text-red-500">*</span>
                            </label>
                            <input type="date" name="stock_items[1][manufacturing_date]" 
                                class="stock-mfg-date w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                value="<?php echo date('Y-m-d'); ?>">
                        </div>

                        <!-- Expired Date -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Tanggal Kadaluarsa <span class="text-red-500">*</span>
                            </label>
                            <input type="date" name="stock_items[1][expired_date]" 
                                class="stock-exp-date w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                value="<?php echo date('Y-m-d', strtotime('+1 year')); ?>">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Add/Remove Buttons -->
            <div class="flex justify-between items-center mt-4">
                <button type="button" onclick="removeLastStockItem()" 
                        class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg transition-colors duration-200">
                    <i class="fas fa-minus mr-2"></i>Hapus Terakhir
                </button>
                <p class="text-sm text-gray-600">
                    Total Items: <span id="totalItems" class="font-semibold">1</span> | 
                    Total Code Barang: <span id="totalCodeBarang" class="font-semibold text-blue-600">0</span>
                </p>
            </div>
        </div>

        <!-- Submit Buttons -->
        <div class="flex justify-end space-x-4 mb-6">
            <button type="button" onclick="backToModeSelection()"
                    class="bg-gray-500 hover:bg-gray-600 text-white px-6 py-3 rounded-lg transition-colors duration-200">
                <i class="fas fa-arrow-left mr-2"></i>Kembali ke Pemilihan Mode
            </button>
            <button type="submit" 
                    class="bg-blue-500 hover:bg-blue-600 text-white px-6 py-3 rounded-lg transition-colors duration-200">
                <i class="fas fa-save mr-2"></i>Submit & Simpan
            </button>
        </div>
    </form>
</div>

<script>
// Counter untuk stock items
let stockItemCounter = 1;
let currentMode = '';
let componentType = '';
let finishComponents = [];
let allComponents = [];
let nextCodeBarang = 1;

// Load components data
<?php 
$result_finish_components->data_seek(0);
echo "finishComponents = " . json_encode($result_finish_components->fetch_all(MYSQLI_ASSOC)) . ";\n";
$result_components->data_seek(0);
echo "allComponents = " . json_encode($result_components->fetch_all(MYSQLI_ASSOC)) . ";\n";
?>

// Load next available code barang
function loadNextCodeBarang() {
    fetch('get_next_code_barang.php')
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                nextCodeBarang = data.next_code;
                document.getElementById('startingCodeBarang').textContent = String(nextCodeBarang).padStart(3, '0');
                updateCodeBarangPreview();
            }
        })
        .catch(error => {
            console.error('Error:', error);
        });
}

// Select Mode
function selectMode(mode) {
    currentMode = mode;
    
    // Remove active class from all options
    document.querySelectorAll('.mode-option').forEach(option => {
        option.classList.remove('border-blue-500', 'bg-blue-50', 'border-green-500', 'bg-green-50');
        option.classList.add('border-gray-300');
    });
    
    // Add active class to selected option
    if (mode === 'only_master') {
        document.getElementById('mode_only_master').classList.remove('border-gray-300');
        document.getElementById('mode_only_master').classList.add('border-blue-500', 'bg-blue-50');
    } else {
        document.getElementById('mode_with_stock').classList.remove('border-gray-300');
        document.getElementById('mode_with_stock').classList.add('border-green-500', 'bg-green-50');
    }
    
    // Show selected mode indicator
    const indicator = document.getElementById('selectedModeIndicator');
    const modeText = document.getElementById('selectedModeText');
    indicator.classList.remove('hidden');
    
    if (mode === 'only_master') {
        modeText.innerHTML = '<strong>Only Master</strong> - Hanya input Master Color & Panel';
        indicator.classList.remove('bg-green-50', 'border-green-200');
        indicator.classList.add('bg-blue-50', 'border-blue-200');
        modeText.classList.remove('text-green-800');
        modeText.classList.add('text-blue-800');
    } else {
        modeText.innerHTML = '<strong>With Components Stock</strong> - Input Master + Stock Items';
        indicator.classList.remove('bg-blue-50', 'border-blue-200');
        indicator.classList.add('bg-green-50', 'border-green-200');
        modeText.classList.remove('text-blue-800');
        modeText.classList.add('text-green-800');
    }
    
    // Show form after 500ms
    setTimeout(() => {
        document.getElementById('formDataWarna').style.display = 'block';
        document.getElementById('input_mode').value = mode;
        
        // Show/hide section 2 based on mode
        if (mode === 'with_stock') {
            document.getElementById('section2Container').style.display = 'block';
            loadNextCodeBarang();
            // Make stock items required
            document.querySelectorAll('.stock-component, .stock-qty, .stock-lemari-number, .stock-lokasi, .stock-mfg-date, .stock-exp-date').forEach(field => {
                field.setAttribute('required', 'required');
            });
            // Make component_type required
            document.querySelectorAll('input[name="component_type"]').forEach(radio => {
                radio.setAttribute('required', 'required');
            });
        } else {
            document.getElementById('section2Container').style.display = 'none';
            // Remove required from stock items
            document.querySelectorAll('.stock-component, .stock-qty, .stock-lemari-number, .stock-lokasi, .stock-mfg-date, .stock-exp-date').forEach(field => {
                field.removeAttribute('required');
            });
            // Remove required from component_type
            document.querySelectorAll('input[name="component_type"]').forEach(radio => {
                radio.removeAttribute('required');
            });
        }
        
        // Scroll to form
        document.getElementById('formDataWarna').scrollIntoView({ behavior: 'smooth', block: 'start' });
    }, 500);
}

// Update component type
function updateComponentType() {
    const selectedType = document.querySelector('input[name="component_type"]:checked')?.value;
    componentType = selectedType;
    
    // Update all existing component selects
    document.querySelectorAll('.stock-component').forEach(select => {
        updateComponentOptions(select);
    });
}

// Update component options based on type
function updateComponentOptions(selectElement) {
    const currentValue = selectElement.value;
    let componentsToUse = componentType === 'finish_only' ? finishComponents : allComponents;
    
    let options = '<option value="">-- Pilih Component --</option>';
    componentsToUse.forEach(component => {
        options += `<option value="${component.id}">${component.component_name}</option>`;
    });
    
    selectElement.innerHTML = options;
    
    // Restore selected value if still valid
    if (currentValue) {
        const optionExists = Array.from(selectElement.options).some(option => option.value === currentValue);
        if (optionExists) {
            selectElement.value = currentValue;
        }
    }
}

// Update code barang preview for all items
function updateCodeBarangPreview() {
    const items = document.querySelectorAll('.stock-item');
    let currentCode = nextCodeBarang;
    let totalCodeBarang = 0;
    
    items.forEach((item, index) => {
        const qtyInput = item.querySelector('.stock-qty');
        const qtyInfoSpan = item.querySelector('.qty-info');
        const startInput = item.querySelector('.code-barang-start');
        const endInput = item.querySelector('.code-barang-end');
        const separator = item.querySelector('.qty-separator');
        
        const qty = parseInt(qtyInput.value) || 0;
        qtyInfoSpan.textContent = qty;
        
        if (qty > 0) {
            if (qty > 1) {
                endInput.style.display = 'block';
                separator.style.display = 'block';
            } else {
                endInput.style.display = 'none';
                separator.style.display = 'none';
            }
            
            if (!startInput.value || startInput.value === '000') {
                startInput.value = String(currentCode).padStart(3, '0');
            }
            
            const startCode = parseInt(startInput.value) || currentCode;
            const endCode = startCode + qty - 1;
            
            endInput.value = String(endCode).padStart(3, '0');
            
            validateCodeBarangInline(startInput, item.dataset.item);
            
            currentCode = endCode + 1;
            totalCodeBarang += qty;
        } else {
            startInput.value = '';
            endInput.value = '';
            endInput.style.display = 'none';
            separator.style.display = 'none';
        }
    });
    
    document.getElementById('totalCodeBarang').textContent = totalCodeBarang;
}

// Validate and update code barang when user edits
function validateAndUpdateCodeBarang(input, itemNumber) {
    let value = input.value.trim();
    
    if (value === '') {
        input.value = '';
        return;
    }
    
    const codeNum = parseInt(value);
    if (isNaN(codeNum) || codeNum < 1) {
        input.value = '';
        return;
    }
    
    if (codeNum > 999) {
        alert('Code Barang maksimal 999!');
        input.value = '';
        return;
    }
    
    input.value = String(codeNum).padStart(3, '0');
    updateCodeBarangPreview();
}

// Validate code barang inline
function validateCodeBarangInline(input, itemNumber) {
    const validationDiv = input.closest('.stock-item').querySelector('.code-barang-validation');
    const codeValue = input.value.trim();
    
    if (!codeValue || codeValue === '000') {
        validationDiv.innerHTML = '';
        return;
    }
    
    validationDiv.innerHTML = '<span class="text-gray-500"><i class="fas fa-spinner fa-spin mr-1"></i>Mengecek...</span>';
    
    fetch('check_code_barang_range.php?code=' + codeValue)
        .then(response => response.json())
        .then(data => {
            if (!data.success) {
                validationDiv.innerHTML = '<span class="text-red-600"><i class="fas fa-exclamation-triangle mr-1"></i>Error checking code</span>';
                return;
            }
            
            if (data.exists) {
                validationDiv.innerHTML = `
                    <div class="text-red-600">
                        <i class="fas fa-times-circle mr-1"></i>
                        <strong>Code barang sudah ada!</strong><br>
                        <span class="text-xs">
                            Master: ${data.data.master_color}<br>
                            Component: ${data.data.component}<br>
                            Lokasi: ${data.data.lokasi}
                        </span>
                    </div>
                `;
                input.classList.add('border-red-500');
                input.classList.remove('border-green-500');
            } else {
                validationDiv.innerHTML = '<span class="text-green-600"><i class="fas fa-check-circle mr-1"></i>Code barang tersedia</span>';
                input.classList.remove('border-red-500');
                input.classList.add('border-green-500');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            validationDiv.innerHTML = '<span class="text-red-600"><i class="fas fa-exclamation-triangle mr-1"></i>Error validasi</span>';
        });
}

// Back to Mode Selection
function backToModeSelection() {
    if (confirm('Kembali ke pemilihan mode? Data yang sudah diisi akan hilang.')) {
        location.reload();
    }
}

// Generate code color
function generateCodeColor() {
    const buyerSelect = document.getElementById('buyer_id');
    const codeColorInput = document.getElementById('code_color');
    
    if (!buyerSelect.value) {
        codeColorInput.value = '';
        return;
    }
    
    const buyerId = buyerSelect.value;
    codeColorInput.value = 'Loading...';
    
    fetch('get_next_code.php?buyer_id=' + buyerId)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                codeColorInput.value = data.code_color;
            } else {
                codeColorInput.value = '';
                alert('Error generating code: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            codeColorInput.value = '';
            alert('Error generating code color');
        });
}

// Load collections
function loadCollections() {
    const buyerId = document.getElementById('buyer_id').value;
    const collectionSelect = document.getElementById('collection_id');
    
    if (!buyerId) {
        collectionSelect.innerHTML = '<option value="">-- Pilih Buyer Terlebih Dahulu --</option>';
        collectionSelect.disabled = true;
        return;
    }
    
    collectionSelect.innerHTML = '<option value="">Loading...</option>';
    collectionSelect.disabled = true;
    
    fetch('get_collections.php?buyer_id=' + buyerId)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                let options = '<option value="">-- Pilih Collection --</option>';
                data.collections.forEach(collection => {
                    options += `<option value="${collection.id}">${collection.nama_collection}</option>`;
                });
                collectionSelect.innerHTML = options;
                collectionSelect.disabled = false;
            } else {
                collectionSelect.innerHTML = '<option value="">-- Tidak Ada Collection --</option>';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            collectionSelect.innerHTML = '<option value="">-- Error Loading Collections --</option>';
        });
}

// Add stock item
function addStockItem() {
    if (!componentType) {
        alert('Silakan pilih tipe component terlebih dahulu!');
        return;
    }
    
    stockItemCounter++;
    
    const container = document.getElementById('stockItemsContainer');
    const newItem = document.createElement('div');
    newItem.className = 'stock-item border border-gray-200 rounded-lg p-4 mb-4 bg-gray-50';
    newItem.setAttribute('data-item', stockItemCounter);
    
    const isRequired = currentMode === 'with_stock' ? 'required' : '';
    
    newItem.innerHTML = `
        <div class="flex items-center justify-between mb-3">
            <h3 class="font-semibold text-gray-800">
                <i class="fas fa-box text-purple-500 mr-2"></i>Item #<span class="item-number">${stockItemCounter}</span>
            </h3>
            <button type="button" onclick="removeStockItem(${stockItemCounter})" 
                    class="text-red-500 hover:text-red-700 transition-colors duration-200 remove-btn">
                <i class="fas fa-trash-alt"></i> Hapus
            </button>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    Component <span class="text-red-500">*</span>
                </label>
                <select name="stock_items[${stockItemCounter}][component_id]" 
                        class="stock-component w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                        data-item="${stockItemCounter}" ${isRequired}>
                    <option value="">-- Pilih Component --</option>
                </select>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    Quantity <span class="text-red-500">*</span>
                </label>
                <input type="number" name="stock_items[${stockItemCounter}][qty]" 
                       class="stock-qty w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                       placeholder="0" min="1" ${isRequired} onchange="updateCodeBarangPreview()">
                <p class="text-xs text-gray-500 mt-1">Akan generate <span class="qty-info">0</span> code barang</p>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    Code Barang Lemari 5 <span class="text-red-500">*</span>
                </label>
                <div class="flex gap-2 items-center">
                    <input type="text" name="stock_items[${stockItemCounter}][code_barang_start]" 
                           class="code-barang-start w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 font-mono text-sm"
                           placeholder="001" maxlength="3" ${isRequired}
                           onkeypress="return event.charCode >= 48 && event.charCode <= 57"
                           onblur="validateAndUpdateCodeBarang(this, ${stockItemCounter})"
                           oninput="this.value = this.value.replace(/[^0-9]/g, '')">
                    <span class="text-gray-500 qty-separator" style="display:none;">-</span>
                    <input type="text" name="stock_items[${stockItemCounter}][code_barang_end]" 
                           class="code-barang-end w-full px-3 py-2 border border-gray-300 rounded-lg bg-gray-100 font-mono text-sm"
                           placeholder="001" readonly style="display:none;">
                </div>
                <div class="code-barang-validation mt-1 text-xs"></div>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    Nomor Lemari <span class="text-red-500">*</span>
                </label>
                <input type="text" name="stock_items[${stockItemCounter}][lemari_number]" 
                    class="stock-lemari-number w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                    placeholder="5, 6, 7, dst" maxlength="10" ${isRequired}>
                <p class="text-xs text-gray-500 mt-1">Nomor lemari untuk stock item ini</p>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    Lokasi Penyimpanan <span class="text-red-500">*</span>
                </label>
                <input type="text" name="stock_items[${stockItemCounter}][lokasi_penyimpanan]" 
                       class="stock-lokasi w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                       placeholder="Contoh: Color Room, Rack A 001" ${isRequired}>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    Tanggal Produksi <span class="text-red-500">*</span>
                </label>
                <input type="date" name="stock_items[${stockItemCounter}][manufacturing_date]" 
                       class="stock-mfg-date w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                       value="<?php echo date('Y-m-d'); ?>" ${isRequired}>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    Tanggal Kadaluarsa <span class="text-red-500">*</span>
                </label>
                <input type="date" name="stock_items[${stockItemCounter}][expired_date]" 
                       class="stock-exp-date w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                       value="<?php echo date('Y-m-d', strtotime('+1 year')); ?>" ${isRequired}>
            </div>
        </div>
    `;
    
    container.appendChild(newItem);
    
    const newSelect = newItem.querySelector('.stock-component');
    updateComponentOptions(newSelect);
    
    updateTotalItems();
    updateRemoveButtons();
    updateCodeBarangPreview();
}

// Remove stock item
function removeStockItem(itemNumber) {
    const item = document.querySelector(`.stock-item[data-item="${itemNumber}"]`);
    if (item) {
        item.remove();
        updateItemNumbers();
        updateTotalItems();
        updateRemoveButtons();
        updateCodeBarangPreview();
    }
}

// Remove last stock item
function removeLastStockItem() {
    const items = document.querySelectorAll('.stock-item');
    if (items.length > 1) {
        items[items.length - 1].remove();
        updateItemNumbers();
        updateTotalItems();
        updateRemoveButtons();
        updateCodeBarangPreview();
    } else {
        alert('Minimal harus ada 1 stock item!');
    }
}

// Update item numbers
function updateItemNumbers() {
    const items = document.querySelectorAll('.stock-item');
    items.forEach((item, index) => {
        const number = index + 1;
        item.querySelector('.item-number').textContent = number;
    });
}

// Update total items
function updateTotalItems() {
    const total = document.querySelectorAll('.stock-item').length;
    document.getElementById('totalItems').textContent = total;
}

// Update remove buttons
function updateRemoveButtons() {
    const items = document.querySelectorAll('.stock-item');
    const removeButtons = document.querySelectorAll('.remove-btn');
    
    if (items.length === 1) {
        removeButtons.forEach(btn => btn.style.display = 'none');
    } else {
        removeButtons.forEach(btn => btn.style.display = 'block');
    }
}

// ========================================
// FORM VALIDATION BEFORE SUBMIT (DIPERBAIKI)
// ========================================
document.getElementById('formDataWarna').addEventListener('submit', function(e) {
    e.preventDefault();
    
    console.log('Form submit triggered, currentMode:', currentMode);
    
    // Validate mode
    if (!currentMode) {
        alert('Silakan pilih mode input data terlebih dahulu!');
        return false;
    }
    
    // Validate code color
    const codeColor = document.getElementById('code_color').value;
    if (!codeColor || codeColor === 'Loading...' || codeColor === '') {
        alert('Silakan pilih Buyer terlebih dahulu untuk generate Code Color!');
        return false;
    }
    
    // Validate buyer dan collection
    const buyerId = document.getElementById('buyer_id').value;
    const collectionId = document.getElementById('collection_id').value;
    
    if (!buyerId) {
        alert('Silakan pilih Buyer!');
        return false;
    }
    
    if (!collectionId) {
        alert('Silakan pilih Collection!');
        return false;
    }
    
    // Validate color_name
    const colorName = document.getElementById('color_name').value;
    if (!colorName || colorName.trim() === '') {
        alert('Silakan isi Nama Warna!');
        return false;
    }
    
    // Validate lemari
    const lemari = document.querySelector('input[name="lemari"]:checked');
    if (!lemari) {
        alert('Silakan pilih Lemari!');
        return false;
    }
    
    // Validate lemari_number
    const lemariNumber = document.getElementById('lemari_number').value;
    if (!lemariNumber || parseInt(lemariNumber) < 1) {
        alert('Silakan isi Nomor Lemari yang valid!');
        return false;
    }
    
    // Validate rack and position
    const rackNumber = document.getElementById('rack_number').value;
    const positionNumber = document.getElementById('position_number').value;
    
    if (!rackNumber || !positionNumber) {
        alert('Silakan isi Nomor Rack dan Nomor Posisi!');
        return false;
    }
    
    // Validate rack format (must be 4 digits)
    if (!/^\d{4}$/.test(rackNumber)) {
        alert('Nomor Rack harus 4 digit! Contoh: 0001');
        return false;
    }
    
    // Validate position format (must be 2 digits)
    if (!/^\d{2}$/.test(positionNumber)) {
        alert('Nomor Posisi harus 2 digit! Contoh: 01');
        return false;
    }
    
    // ========================================
    // VALIDASI BERBEDA BERDASARKAN MODE
    // ========================================
    
    if (currentMode === 'with_stock') {
        console.log('Validating WITH STOCK mode');
        
        // MODE: WITH STOCK - Validasi stock items
        const componentTypeSelected = document.querySelector('input[name="component_type"]:checked');
        if (!componentTypeSelected) {
            alert('Silakan pilih tipe component!');
            return false;
        }
        
        const stockItems = document.querySelectorAll('.stock-item');
        if (stockItems.length === 0) {
            alert('Minimal harus ada 1 stock item untuk mode "With Components Stock"!');
            return false;
        }
        
        // Validate each stock item
        let allValid = true;
        let totalQty = 0;
        let allCodeBarang = [];
        
        stockItems.forEach((item, index) => {
            const component = item.querySelector('.stock-component').value;
            const qty = parseInt(item.querySelector('.stock-qty').value) || 0;
            const codeBarangStart = item.querySelector('.code-barang-start').value;
            const lemariNumber = item.querySelector('.stock-lemari-number').value;
            const lokasi = item.querySelector('.stock-lokasi').value;
            const mfgDate = item.querySelector('.stock-mfg-date').value;
            const expDate = item.querySelector('.stock-exp-date').value;
            
            if (!component || !qty || !codeBarangStart || !lemariNumber || !lokasi || !mfgDate || !expDate) {
                alert(`Item #${index + 1}: Semua field harus diisi!`);
                allValid = false;
                return false;
            }
            
            if (qty < 1) {
                alert(`Item #${index + 1}: Quantity minimal 1!`);
                allValid = false;
                return false;
            }
            
            // Validate code barang format
            if (!/^\d{3}$/.test(codeBarangStart)) {
                alert(`Item #${index + 1}: Code Barang harus 3 digit!`);
                allValid = false;
                return false;
            }
            
            // Check if has error border (code already exists)
            if (item.querySelector('.code-barang-start').classList.contains('border-red-500')) {
                alert(`Item #${index + 1}: Code Barang sudah digunakan! Silakan gunakan code yang lain.`);
                allValid = false;
                return false;
            }
            
            // Collect all code barang for this item
            const startCode = parseInt(codeBarangStart);
            for (let i = 0; i < qty; i++) {
                const code = String(startCode + i).padStart(3, '0');
                if (allCodeBarang.includes(code)) {
                    alert(`Item #${index + 1}: Code Barang ${code} duplikat dalam form!`);
                    allValid = false;
                    return false;
                }
                allCodeBarang.push(code);
            }
            
            totalQty += qty;
        });
        
        if (!allValid) return false;
        
        // Confirm total code barang to be generated
        const minCode = Math.min(...allCodeBarang.map(c => parseInt(c)));
        const maxCode = Math.max(...allCodeBarang.map(c => parseInt(c)));
        
        const confirmMsg = `Apakah Anda yakin ingin menyimpan data ini?\n\n` +
                          `Mode: With Components Stock\n` +
                          `Total Item: ${stockItems.length}\n` +
                          `Total Code Barang yang akan di-generate: ${totalQty}\n` +
                          `Range Code Barang: ${String(minCode).padStart(3, '0')} - ${String(maxCode).padStart(3, '0')}`;
        
        if (!confirm(confirmMsg)) {
            return false;
        }
        
    } else {
        console.log('Validating ONLY MASTER mode');
        
        // MODE: ONLY MASTER - Validasi sederhana saja
        const confirmMsg = `Apakah Anda yakin ingin menyimpan data ini?\n\n` +
                          `Mode: Only Master\n` +
                          `Code Color: ${codeColor}\n` +
                          `Nama Warna: ${colorName}\n` +
                          `Lemari: ${lemari.value}${lemariNumber}\n` +
                          `Rack: ${rackNumber}, Posisi: ${positionNumber}`;
        
        if (!confirm(confirmMsg)) {
            return false;
        }
    }
    
    console.log('All validations passed, submitting form...');
    
    // Disable submit button and change text
    const submitBtn = this.querySelector('button[type="submit"]');
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Memproses...';
    
    // Submit form
    this.submit();
});

// Validate rack number
document.getElementById('rack_number').addEventListener('blur', function() {
    let value = this.value.trim();
    
    if (value === '') return;
    
    const rackNum = parseInt(value);
    
    if (isNaN(rackNum) || rackNum < 1) {
        alert('Nomor Rack harus berupa angka positif!');
        this.value = '';
        return;
    }
    
    this.value = String(rackNum).padStart(4, '0');
});

document.getElementById('rack_number').addEventListener('keypress', function(e) {
    if (e.key < '0' || e.key > '9') {
        e.preventDefault();
    }
});

// Validate position number
document.getElementById('position_number').addEventListener('blur', function() {
    let value = this.value.trim();
    
    if (value === '') return;
    
    const posNum = parseInt(value);
    
    if (isNaN(posNum) || posNum < 1) {
        alert('Nomor Posisi harus berupa angka positif!');
        this.value = '';
        return;
    }
    
    this.value = String(posNum).padStart(2, '0');
});

document.getElementById('position_number').addEventListener('keypress', function(e) {
    if (e.key < '0' || e.key > '9') {
        e.preventDefault();
    }
});

// Initialize
document.addEventListener('DOMContentLoaded', function() {
    updateRemoveButtons();
    updateTotalItems();
});
</script>

<?php
include '../template_it/footer.php';
?>